/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.util.I2PAppThread;
import net.i2p.util.InternalServerSocket;
import net.i2p.util.Log;

class InternalSocketRunner
extends I2PAppThread {
    private final I2PTunnelClientBase client;
    private final int port;
    private ServerSocket ss;
    private volatile boolean open;

    InternalSocketRunner(I2PTunnelClientBase client) {
        super("Internal socket port " + client.getLocalPort());
        this.setDaemon(true);
        this.client = client;
        this.port = client.getLocalPort();
    }

    @Override
    public final void run() {
        block3: {
            try {
                this.ss = new InternalServerSocket(this.port);
                this.open = true;
                while (this.open) {
                    Socket s = this.ss.accept();
                    this.client.manageConnection(s);
                }
            }
            catch (IOException ex) {
                if (!this.open) break block3;
                Log log = new Log(InternalSocketRunner.class);
                log.error("Error listening for internal connections on port " + this.port, ex);
                this.stopRunning();
            }
        }
    }

    void stopRunning() {
        if (this.open) {
            this.open = false;
            try {
                this.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

