/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.IResParser;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlSecurity;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestAttributes {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestAttributes.class);
    private static final String ATTR_XML = "/android/attrs.xml";
    private static final String MANIFEST_ATTR_XML = "/android/attrs_manifest.xml";
    private final Map<String, MAttr> attrMap = new HashMap<String, MAttr>();
    private final Map<String, MAttr> appAttrMap = new HashMap<String, MAttr>();
    private static ManifestAttributes instance;

    public static ManifestAttributes getInstance() {
        if (instance == null) {
            try {
                instance = new ManifestAttributes();
            }
            catch (Exception e) {
                LOG.error("Failed to create ManifestAttributes", (Throwable)e);
            }
        }
        return instance;
    }

    private ManifestAttributes() {
        this.parseAll();
    }

    private void parseAll() {
        this.parse(this.loadXML(ATTR_XML));
        this.parse(this.loadXML(MANIFEST_ATTR_XML));
        LOG.debug("Loaded android attributes count: {}", (Object)this.attrMap.size());
    }

    private Document loadXML(String xml) {
        Document doc;
        try (InputStream xmlStream = ManifestAttributes.class.getResourceAsStream(xml);){
            if (xmlStream == null) {
                throw new JadxRuntimeException(xml + " not found in classpath");
            }
            DocumentBuilder dBuilder = XmlSecurity.getSecureDbf().newDocumentBuilder();
            doc = dBuilder.parse(xmlStream);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Xml load error, file: " + xml, e);
        }
        return doc;
    }

    private void parse(Document doc) {
        NodeList nodeList = doc.getChildNodes();
        for (int count = 0; count < nodeList.getLength(); ++count) {
            Node node = nodeList.item(count);
            if (node.getNodeType() != 1 || !node.hasChildNodes()) continue;
            this.parseAttrList(node.getChildNodes());
        }
    }

    private void parseAttrList(NodeList nodeList) {
        for (int count = 0; count < nodeList.getLength(); ++count) {
            Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() != 1 || !tempNode.hasAttributes() || !tempNode.hasChildNodes()) continue;
            String name = null;
            NamedNodeMap nodeMap = tempNode.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node node = nodeMap.item(i);
                if (!node.getNodeName().equals("name")) continue;
                name = node.getNodeValue();
                break;
            }
            if (name != null && tempNode.getNodeName().equals("attr")) {
                this.parseValues(name, tempNode.getChildNodes());
                continue;
            }
            this.parseAttrList(tempNode.getChildNodes());
        }
    }

    private void parseValues(String name, NodeList nodeList) {
        MAttr attr = null;
        for (int count = 0; count < nodeList.getLength(); ++count) {
            Node valueNode;
            NamedNodeMap attributes;
            Node nameNode;
            Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() != 1 || !tempNode.hasAttributes()) continue;
            if (attr == null) {
                if (tempNode.getNodeName().equals("enum")) {
                    attr = new MAttr(MAttrType.ENUM);
                } else if (tempNode.getNodeName().equals("flag")) {
                    attr = new MAttr(MAttrType.FLAG);
                }
                if (attr == null) {
                    return;
                }
                this.attrMap.put(name, attr);
            }
            if ((nameNode = (attributes = tempNode.getAttributes()).getNamedItem("name")) == null || (valueNode = attributes.getNamedItem("value")) == null) continue;
            try {
                long key;
                String nodeValue = valueNode.getNodeValue();
                if (nodeValue.startsWith("0x")) {
                    nodeValue = nodeValue.substring(2);
                    key = Long.parseLong(nodeValue, 16);
                } else {
                    key = Long.parseLong(nodeValue);
                }
                attr.getValues().put(key, nameNode.getNodeValue());
                continue;
            }
            catch (NumberFormatException e) {
                LOG.debug("Failed parse manifest number", (Throwable)e);
            }
        }
    }

    public String decode(String attrName, long value) {
        MAttr attr = this.attrMap.get(attrName);
        if (attr == null && (attr = this.appAttrMap.get(attrName)) == null) {
            return null;
        }
        if (attr.getType() == MAttrType.ENUM) {
            return attr.getValues().get(value);
        }
        if (attr.getType() == MAttrType.FLAG) {
            ArrayList<String> flagList = new ArrayList<String>();
            ArrayList<Long> attrKeys = new ArrayList<Long>(attr.getValues().keySet());
            attrKeys.sort((a, b) -> Long.compare(b, a));
            for (Long key : attrKeys) {
                String attrValue = attr.getValues().get(key);
                if (value == key) {
                    flagList.add(attrValue);
                    break;
                }
                if (key == 0L || (value & key) != key) continue;
                flagList.add(attrValue);
                value ^= key.longValue();
            }
            return String.join((CharSequence)"|", flagList);
        }
        return null;
    }

    public void updateAttributes(IResParser parser) {
        this.appAttrMap.clear();
        ResourceStorage resStorage = parser.getResStorage();
        ValuesParser vp = new ValuesParser(parser.getStrings(), resStorage.getResourcesNames());
        for (ResourceEntry ri : resStorage.getResources()) {
            MAttrType attrTyp;
            if (!ri.getTypeName().equals("attr") || ri.getNamedValues().size() <= 1) continue;
            RawNamedValue first = ri.getNamedValues().get(0);
            if (first.getRawValue().getData() == 131072) {
                attrTyp = MAttrType.FLAG;
            } else {
                if (first.getRawValue().getData() != 65536 && first.getRawValue().getData() != 65600) continue;
                attrTyp = MAttrType.ENUM;
            }
            MAttr attr = new MAttr(attrTyp);
            for (int i = 1; i < ri.getNamedValues().size(); ++i) {
                RawNamedValue rv = ri.getNamedValues().get(i);
                String value = vp.decodeNameRef(rv.getNameRef());
                attr.getValues().put(Long.valueOf(rv.getRawValue().getData()), value.startsWith("id.") ? value.substring(3) : value);
            }
            this.appAttrMap.put(ri.getKeyName(), attr);
        }
    }

    private static class MAttr {
        private final MAttrType type;
        private final Map<Long, String> values = new LinkedHashMap<Long, String>();

        public MAttr(MAttrType type) {
            this.type = type;
        }

        public MAttrType getType() {
            return this.type;
        }

        public Map<Long, String> getValues() {
            return this.values;
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + ", " + this.values + ']';
        }
    }

    private static enum MAttrType {
        ENUM,
        FLAG;

    }
}

