/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.spi.SaasClientCodeGenerationProvider;
import org.netbeans.modules.websvc.saas.codegen.util.UniqueVariableNameFinder;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

public abstract class SaasClientCodeGenerator
implements SaasClientCodeGenerationProvider {
    public static final String REST_CONNECTION = "RestConnection";
    public static final String REST_RESPONSE = "RestResponse";
    public static final String REST_CONNECTION_PACKAGE = "org.netbeans.saas";
    public static final String SAAS_SERVICES = "SaaSServices";
    public static final String TEMPLATES_SAAS = "Templates/SaaSServices/";
    public static final String REST_CONNECTION_TEMPLATE = "Templates/SaaSServices/RestConnection.java";
    public static final String REST_RESPONSE_TEMPLATE = "Templates/SaaSServices/RestResponse.java";
    public static final String COMMENT_END_OF_HTTP_MEHTOD_GET = "TODO return proper representation object";
    public static final String GENERIC_REF_CONVERTER_TEMPLATE = "Templates/SaaSServices/RefConverter.java";
    public static final String GENERIC_REF_CONVERTER = "GenericRefConverter";
    public static final String CONVERTER_SUFFIX = "Converter";
    public static final String CONVERTER_FOLDER = "converter";
    public static final String RESOURCE_SUFFIX = "Resource";
    public static final String VAR_NAMES_RESULT_DECL = "RestResponse result";
    public static final String INDENT = "        ";
    public static final String INDENT_2 = "             ";
    private FileObject targetFile;
    private FileObject destDir;
    private Project project;
    private SaasBean bean;
    private Document targetDocument;
    private int start = 0;
    private int end = 0;
    private ProgressHandle pHandle;
    private int totalWorkUnits;
    private int workUnits;
    private Constants.DropFileType dropFileType;
    private int precedence;
    private UniqueVariableNameFinder nFinder = new UniqueVariableNameFinder();

    protected Document getTargetDocument() {
        return this.targetDocument;
    }

    protected FileObject getTargetFile() {
        return this.targetFile;
    }

    protected FileObject getTargetFolder() {
        return this.destDir;
    }

    protected Project getProject() {
        return this.project;
    }

    public int getStartPosition() {
        return this.start;
    }

    public void setStartPosition(int start) {
        this.start = start;
    }

    public int getEndPosition() {
        return this.end;
    }

    public void setEndPosition(int end) {
        this.end = end;
    }

    public Constants.DropFileType getDropFileType() {
        return this.dropFileType;
    }

    public void setDropFileType(Constants.DropFileType dropFileType) {
        this.dropFileType = dropFileType;
    }

    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    public void initProgressReporting(ProgressHandle pHandle) {
        this.initProgressReporting(pHandle, true);
    }

    public void initProgressReporting(ProgressHandle pHandle, boolean start) {
        this.pHandle = pHandle;
        this.totalWorkUnits = this.getTotalWorkUnits();
        this.workUnits = 0;
        if (pHandle != null && start) {
            if (this.totalWorkUnits > 0) {
                pHandle.start(this.totalWorkUnits);
            } else {
                pHandle.start();
            }
        }
    }

    public void reportProgress(String message) {
        if (this.pHandle != null) {
            if (this.totalWorkUnits > 0) {
                this.pHandle.progress(message, ++this.workUnits);
            } else {
                this.pHandle.progress(message);
            }
        }
    }

    public void finishProgressReporting() {
        if (this.pHandle != null) {
            this.pHandle.finish();
        }
    }

    public int getTotalWorkUnits() {
        return 0;
    }

    protected ProgressHandle getProgressHandle() {
        return this.pHandle;
    }

    @Override
    public abstract boolean canAccept(SaasMethod var1, Document var2);

    @Override
    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        FileObject[] result = new FileObject[]{this.getTargetFile()};
        this.finishProgressReporting();
        return new HashSet<FileObject>(Arrays.asList(result));
    }

    @Override
    public void init(SaasMethod method, Document doc) throws IOException {
        if (doc == null) {
            throw new IOException("Cannot generate, target document is null.");
        }
        this.targetDocument = doc;
        this.targetFile = NbEditorUtilities.getFileObject((Document)this.targetDocument);
        this.destDir = this.targetFile.getParent();
        this.project = FileOwnerQuery.getOwner((FileObject)this.targetFile);
        if (this.project == null) {
            throw new IllegalArgumentException(this.targetFile.getPath() + " is not part of a project.");
        }
    }

    protected void preGenerate() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String resourceName, File destFile) throws IOException {
        String path = resourceName;
        if (!destFile.exists()) {
            InputStream is = null;
            OutputStream os = null;
            try {
                int c;
                is = this.getClass().getResourceAsStream(path);
                os = new FileOutputStream(destFile);
                while ((c = is.read()) != -1) {
                    os.write(c);
                }
            }
            finally {
                if (os != null) {
                    os.flush();
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    protected abstract String getCustomMethodBody() throws IOException;

    public SaasBean getBean() {
        return this.bean;
    }

    public void setBean(SaasBean bean) {
        this.bean = bean;
    }

    private String getParamList() {
        List<ParameterInfo> inputParams = this.bean.filterParametersByAuth(this.bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        String text = "";
        for (int i = 0; i < inputParams.size(); ++i) {
            ParameterInfo param = inputParams.get(i);
            text = i == 0 ? text + this.getParameterName(param, true, true, true) : text + ", " + this.getParameterName(param, true, true, true);
        }
        return text;
    }

    protected void insert(String s, boolean reformat) throws BadLocationException {
        Document doc = this.getTargetDocument();
        if (doc == null) {
            return;
        }
        if (s == null) {
            return;
        }
        this.insert(s, this.getStartPosition(), this.getEndPosition(), doc, reformat);
    }

    protected int insert(String s, int start, int end, Document doc, boolean reformat) throws BadLocationException {
        try {
            doc.remove(start, end - start);
            doc.insertString(start, s, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (reformat) {
            this.reformat(doc, 0, doc.getLength());
        }
        return start;
    }

    protected boolean isInBlock(Document doc) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reformat(Document doc, final int start, final int end) throws BadLocationException {
        final Reformat reformat = Reformat.get((Document)doc);
        final BadLocationException[] ble = new BadLocationException[1];
        reformat.lock();
        try {
            NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        reformat.reformat(start, end);
                    }
                    catch (BadLocationException e) {
                        ble[0] = e;
                    }
                }
            });
        }
        finally {
            reformat.unlock();
        }
        if (ble[0] != null) {
            throw ble[0];
        }
    }

    protected String[] getGetParamNames(List<ParameterInfo> queryParams) {
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(Arrays.asList(this.getParamNames(queryParams)));
        return params.toArray(new String[0]);
    }

    protected String[] getGetParamTypes(List<ParameterInfo> queryParams) {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(Arrays.asList(this.getParamTypeNames(queryParams)));
        return types.toArray(new String[0]);
    }

    protected String[] getParamNames(List<ParameterInfo> params) {
        ArrayList<String> results = new ArrayList<String>();
        for (ParameterInfo param : params) {
            results.add(this.getParameterName(param, true, true, true));
        }
        return results.toArray(new String[0]);
    }

    protected String[] getParamTypeNames(List<ParameterInfo> params) {
        ArrayList<String> results = new ArrayList<String>();
        for (ParameterInfo param : params) {
            results.add(param.getTypeName());
        }
        return results.toArray(new String[0]);
    }

    protected String getParameterName(ParameterInfo param) {
        return Util.getParameterName(param);
    }

    protected String getParameterName(ParameterInfo param, boolean camelize, boolean normalize) {
        return Util.getParameterName(param, camelize, normalize, false);
    }

    protected String getParameterName(ParameterInfo param, boolean camelize, boolean normalize, boolean trimBraces) {
        return Util.getParameterName(param, camelize, normalize, trimBraces);
    }

    protected String getVariableName(String name) {
        return Util.getVariableName(name, true, true, true);
    }

    protected String getVariableName(String name, boolean camelize, boolean normalize, boolean trimBraces) {
        return Util.getVariableName(name, camelize, normalize, trimBraces);
    }

    protected Object[] getParamValues(List<ParameterInfo> params) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (ParameterInfo param : params) {
            Object defaultValue = null;
            if (param.getStyle() != ParameterInfo.ParamStyle.QUERY) {
                defaultValue = param.getDefaultValue();
            }
            results.add(defaultValue);
        }
        return results.toArray(new Object[0]);
    }

    public void setDropLocation(JTextComponent targetComponent) {
        Caret caret = targetComponent.getCaret();
        this.setStartPosition(Math.min(caret.getDot(), caret.getMark()));
        this.setEndPosition(Math.max(caret.getDot(), caret.getMark()));
    }

    protected String findNewName(String pattern, String oldName) {
        this.updateVariableDecl(pattern);
        return this.nFinder.findNewName(pattern, oldName);
    }

    protected String getResultPattern() {
        return "result" + this.nFinder.getVariableCount(VAR_NAMES_RESULT_DECL);
    }

    protected void addVariablePattern(String pattern, int count) {
        this.nFinder.addPattern(pattern, count);
    }

    protected void updateVariableNames(List<ParameterInfo> params) {
        this.nFinder.addPattern(VAR_NAMES_RESULT_DECL, 0);
        try {
            String text = this.getTargetDocument().getText(0, this.getTargetDocument().getLength());
            this.nFinder.updateVariableDecl(text, params);
            this.nFinder.updateVariableDecl(text, VAR_NAMES_RESULT_DECL);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void updateVariableNamesForWS(List<? extends WSParameter> params) {
        this.nFinder.addPattern(VAR_NAMES_RESULT_DECL, 0);
        try {
            String text = this.getTargetDocument().getText(0, this.getTargetDocument().getLength());
            this.nFinder.updateVariableDeclForWS(text, params);
            this.nFinder.updateVariableDecl(text, VAR_NAMES_RESULT_DECL);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void updateVariableDecl(String pattern) {
        try {
            this.nFinder.updateVariableDecl(this.getTargetDocument().getText(0, this.getTargetDocument().getLength()), pattern);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected List<ParameterInfo> renameParameterNames(List<ParameterInfo> params) {
        return this.nFinder.renameParameterNames(params);
    }

    public String getVariableDecl(ParameterInfo p) {
        return this.nFinder.getVariableDecl(p);
    }

    public String getVariableDecl(WSParameter p) {
        return this.nFinder.getVariableDecl(p);
    }

    protected void clearVariablePatterns() {
        this.nFinder.clearPatterns();
    }
}

