/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.netbeans.validation.localization.LocalizationSupport;

public enum Severity {
    INFO,
    WARNING,
    FATAL;

    private BufferedImage image;
    BufferedImage badge;

    public synchronized BufferedImage image() {
        if (this.image == null) {
            String name;
            switch (this) {
                case INFO: {
                    name = "info.png";
                    break;
                }
                case WARNING: {
                    name = "warning.png";
                    break;
                }
                case FATAL: {
                    name = "error.png";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            try {
                this.image = ImageIO.read(Severity.class.getResourceAsStream(name));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return this.image;
    }

    public Icon icon() {
        return new ImageIcon(this.image());
    }

    public Color color() {
        switch (this) {
            case FATAL: {
                Color c = UIManager.getColor("nb.errorForeground");
                if (c == null) {
                    c = Color.RED.darker();
                }
                return c;
            }
            case WARNING: {
                return Color.BLUE.darker();
            }
            case INFO: {
                return UIManager.getColor("textText");
            }
        }
        throw new AssertionError();
    }

    public BufferedImage badge() {
        if (this.badge == null) {
            String name;
            switch (this) {
                case INFO: {
                    name = "info-badge.png";
                    break;
                }
                case WARNING: {
                    name = "warning-badge.png";
                    break;
                }
                case FATAL: {
                    name = "error-badge.png";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            try {
                this.badge = ImageIO.read(Severity.class.getResourceAsStream(name));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return this.badge;
    }

    public String describeError(String toDescribe) {
        return LocalizationSupport.getMessage(Severity.class, this.name() + ".annotation", toDescribe);
    }

    public String toString() {
        return LocalizationSupport.getMessage(Severity.class, this.name(), new Object[0]);
    }
}

