/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.Application;
import org.netbeans.modules.web.jsf.api.facesmodel.ResourceBundle;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.openide.filesystems.FileObject;

public class JSFResourceBundlesProvider {
    private static final Logger LOGGER = Logger.getLogger(JSFResourceBundlesProvider.class.getName());

    public static List<org.netbeans.modules.web.el.spi.ResourceBundle> getResourceBundles(Project project) {
        MetadataModel<JsfModel> model = JSFUtils.getModel(project);
        if (model == null) {
            return Collections.emptyList();
        }
        try {
            return (List)model.runReadAction(metadata -> {
                List<Application> applications = metadata.getElements(Application.class);
                ArrayList<org.netbeans.modules.web.el.spi.ResourceBundle> result = new ArrayList<org.netbeans.modules.web.el.spi.ResourceBundle>();
                for (Application application : applications) {
                    for (ResourceBundle bundle : application.getResourceBundles()) {
                        FileObject bundleFile;
                        if (bundle.getBaseName() == null) continue;
                        ArrayList<FileObject> files = new ArrayList<FileObject>();
                        for (SourceGroup sourceGroup : SourceGroups.getJavaSourceGroups((Project)project)) {
                            bundleFile = JSFResourceBundlesProvider.getBundleFileInSourceGroup(sourceGroup, bundle);
                            if (bundleFile == null) continue;
                            files.add(bundleFile);
                        }
                        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("resources")) {
                            bundleFile = JSFResourceBundlesProvider.getBundleFileInSourceGroup(sourceGroup, bundle);
                            if (bundleFile == null) continue;
                            files.add(bundleFile);
                        }
                        result.add(new org.netbeans.modules.web.el.spi.ResourceBundle(bundle.getBaseName(), bundle.getVar(), files));
                    }
                }
                return result;
            });
        }
        catch (IOException | IllegalStateException ex) {
            LOGGER.log(Level.INFO, "Failed to read resource bundles for " + project, ex);
            return Collections.emptyList();
        }
    }

    private static FileObject getBundleFileInSourceGroup(SourceGroup sourceGroup, ResourceBundle bundle) {
        int lastDelim = bundle.getBaseName().lastIndexOf("/");
        String bundleName = bundle.getBaseName().substring(lastDelim + 1);
        if (lastDelim <= 0) {
            return JSFResourceBundlesProvider.getBundleInFolder(sourceGroup.getRootFolder(), bundleName);
        }
        String parentFolder = bundle.getBaseName().replace(".", "/").substring(0, lastDelim);
        return JSFResourceBundlesProvider.getBundleInFolder(sourceGroup.getRootFolder().getFileObject(parentFolder), bundleName);
    }

    private static FileObject getBundleInFolder(FileObject folder, String bundleName) {
        if (folder != null && folder.isValid() && folder.isFolder()) {
            for (FileObject fo : folder.getChildren()) {
                if (!fo.getName().startsWith(bundleName) || !"properties".equals(fo.getExt())) continue;
                return fo;
            }
        }
        return null;
    }
}

