/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.OAuth2ClientCredential;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateOAuthClientCredentialResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private OAuth2ClientCredential oAuth2ClientCredential;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public OAuth2ClientCredential getOAuth2ClientCredential() {
        return this.oAuth2ClientCredential;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "oAuth2ClientCredential"})
    private CreateOAuthClientCredentialResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, OAuth2ClientCredential oAuth2ClientCredential) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.oAuth2ClientCredential = oAuth2ClientCredential;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",oAuth2ClientCredential=").append(String.valueOf((Object)this.oAuth2ClientCredential));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOAuthClientCredentialResponse)) {
            return false;
        }
        CreateOAuthClientCredentialResponse other = (CreateOAuthClientCredentialResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.oAuth2ClientCredential, (Object)other.oAuth2ClientCredential);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.oAuth2ClientCredential == null ? 43 : this.oAuth2ClientCredential.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateOAuthClientCredentialResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private OAuth2ClientCredential oAuth2ClientCredential;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder oAuth2ClientCredential(OAuth2ClientCredential oAuth2ClientCredential) {
            this.oAuth2ClientCredential = oAuth2ClientCredential;
            return this;
        }

        public Builder copy(CreateOAuthClientCredentialResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.oAuth2ClientCredential(o.getOAuth2ClientCredential());
            return this;
        }

        public CreateOAuthClientCredentialResponse build() {
            return new CreateOAuthClientCredentialResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.oAuth2ClientCredential);
        }
    }
}

