/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.test;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.modules.java.hints.declarative.test.TestLocatorImpl;
import org.netbeans.modules.java.hints.declarative.test.TestParser;
import org.netbeans.modules.java.hints.declarative.test.TestPerformer;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditorTestPerformer
extends ParserResultTask<TestParser.TestResult> {
    private static final Logger LOG = Logger.getLogger(EditorTestPerformer.class.getName());
    private static final AttributeSet PASSED = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.GREEN});
    private static final AttributeSet FAILED = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.RED});
    private final AtomicBoolean cancel = new AtomicBoolean();

    public void run(TestParser.TestResult result, SchedulerEvent event) {
        TestParser.TestCase[] tests = result.getTests();
        FileObject file = result.getSnapshot().getSource().getFileObject();
        FileObject ruleFile = TestLocatorImpl.findOpposite(file, false);
        if (ruleFile == null) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!(doc instanceof StyledDocument)) {
            return;
        }
        StyledDocument sdoc = (StyledDocument)doc;
        try {
            LinkedList<ErrorDescription> errors = new LinkedList<ErrorDescription>();
            OffsetsBag bag = new OffsetsBag(doc);
            Map<TestParser.TestCase, Collection<String>> testResults = TestPerformer.performTest(ruleFile, file, tests, this.cancel);
            if (testResults == null || this.cancel.get()) {
                return;
            }
            for (Map.Entry<TestParser.TestCase, Collection<String>> e : testResults.entrySet()) {
                if (this.cancel.get()) {
                    return;
                }
                TestParser.TestCase tc = e.getKey();
                String[] golden = tc.getResults();
                String[] real = e.getValue().toArray(new String[0]);
                boolean passed = true;
                if (golden.length != real.length) {
                    int line = NbDocument.findLineNumber((StyledDocument)sdoc, (int)tc.getTestCaseStart()) + 1;
                    ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)("Incorrect number of outputs, expected: " + golden.length + ", was: " + real.length), (Document)doc, (int)line);
                    errors.add(ed);
                    passed = false;
                }
                for (int cntr = 0; cntr < Math.min(golden.length, real.length); ++cntr) {
                    String goldenText = golden[cntr];
                    String realText = real[cntr];
                    if (TestPerformer.normalize(goldenText).equals(TestPerformer.normalize(realText))) continue;
                    int line = NbDocument.findLineNumber((StyledDocument)sdoc, (int)tc.getResultsStart()[cntr]);
                    List<FixImpl> fixes = Collections.singletonList(new FixImpl(tc.getResultsStart()[cntr], tc.getResultsEnd()[cntr], sdoc, realText));
                    ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)"Incorrect output", fixes, (Document)doc, (int)line);
                    errors.add(ed);
                    passed = false;
                }
                bag.addHighlight(tc.getTestCaseStart() + "%%TestCase ".length(), tc.getCodeStart() - 1, passed ? PASSED : FAILED);
            }
            EditorTestPerformer.getBag(doc).setHighlights(bag);
            HintsController.setErrors((Document)doc, (String)EditorTestPerformer.class.getName(), errors);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    @NonNull
    static OffsetsBag getBag(@NonNull Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(EditorTestPerformer.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(EditorTestPerformer.class, bag);
        }
        return bag;
    }

    private static final class FixImpl
    implements Fix {
        private final int start;
        private final int end;
        private final StyledDocument doc;
        private final String text;

        public FixImpl(int start, int end, StyledDocument doc, String text) {
            this.start = start;
            this.end = end;
            this.doc = doc;
            this.text = text;
        }

        public String getText() {
            return "Put actual output into golden section";
        }

        public ChangeInfo implement() throws Exception {
            NbDocument.runAtomic((StyledDocument)this.doc, () -> {
                try {
                    this.doc.remove(this.start, this.end - this.start);
                    this.doc.insertString(this.start, this.text, null);
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException(ex);
                }
            });
            return null;
        }
    }

    public static final class FactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new EditorTestPerformer());
        }
    }
}

