/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.netbeans.core.NbLifecycleManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.popupswitcher.KeyboardPopupSwitcher;
import org.openide.actions.ActionManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

final class ShortcutAndMenuKeyEventProcessor
implements KeyEventDispatcher,
KeyEventPostProcessor,
AWTEventListener {
    private static ShortcutAndMenuKeyEventProcessor defaultInstance;
    private static boolean installed;
    private static Set<AWTKeyStroke> defaultForward;
    private static Set<AWTKeyStroke> defaultBackward;
    private static final Logger log;
    private boolean wasPopupDisplayed;
    private int lastModifiers;
    private char lastKeyChar;
    private boolean lastSampled = false;
    private boolean skipNextTyped = false;

    private ShortcutAndMenuKeyEventProcessor() {
    }

    private static synchronized ShortcutAndMenuKeyEventProcessor getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ShortcutAndMenuKeyEventProcessor();
        }
        return defaultInstance;
    }

    public static synchronized void install() {
        if (installed) {
            return;
        }
        ShortcutAndMenuKeyEventProcessor instance = ShortcutAndMenuKeyEventProcessor.getDefault();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(instance);
        keyboardFocusManager.addKeyEventPostProcessor(instance);
        defaultForward = keyboardFocusManager.getDefaultFocusTraversalKeys(0);
        defaultBackward = keyboardFocusManager.getDefaultFocusTraversalKeys(1);
        keyboardFocusManager.setDefaultFocusTraversalKeys(0, Collections.singleton(AWTKeyStroke.getAWTKeyStroke(9, 0)));
        keyboardFocusManager.setDefaultFocusTraversalKeys(1, Collections.singleton(AWTKeyStroke.getAWTKeyStroke(9, 64)));
        Toolkit.getDefaultToolkit().addAWTEventListener(instance, 16L);
    }

    public static synchronized void uninstall() {
        if (!installed) {
            return;
        }
        ShortcutAndMenuKeyEventProcessor instance = ShortcutAndMenuKeyEventProcessor.getDefault();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removeKeyEventDispatcher(instance);
        keyboardFocusManager.removeKeyEventPostProcessor(instance);
        keyboardFocusManager.setDefaultFocusTraversalKeys(0, defaultForward);
        keyboardFocusManager.setDefaultFocusTraversalKeys(1, defaultBackward);
        defaultBackward = null;
        defaultForward = null;
        Toolkit.getDefaultToolkit().removeAWTEventListener(instance);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)event);
        }
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent ev) {
        if (ev.isConsumed()) {
            return false;
        }
        if (this.processShortcut(ev)) {
            return true;
        }
        Window w = SwingUtilities.windowForComponent(ev.getComponent());
        if (w instanceof Dialog && !WindowManagerImpl.isSeparateWindow(w)) {
            return false;
        }
        JFrame mw = (JFrame)WindowManagerImpl.getInstance().getMainWindow();
        if (w == mw) {
            return false;
        }
        JMenuBar mb = mw.getJMenuBar();
        if (mb == null) {
            return false;
        }
        boolean pressed = ev.getID() == 401;
        boolean res = ShortcutAndMenuKeyEventProcessor.invokeProcessKeyBindingsForAllComponents(ev, mw, pressed);
        if (res) {
            ev.consume();
        }
        return res;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ev) {
        MenuElement[] arr;
        log.fine("dispatchKeyEvent ev: " + ev.paramString() + " source:" + ev.getSource().getClass().getName());
        if (NbKeymap.getContext().length != 0) {
            if (ev.getID() != 401) {
                ev.consume();
                return true;
            }
            this.skipNextTyped = true;
            Component comp = ev.getComponent();
            if (!(comp instanceof JComponent) || ((JComponent)comp).getClientProperty("context-api-aware") == null) {
                this.processShortcut(ev);
                return true;
            }
        }
        if (ev.getID() == 401 && ev.getModifiers() == 3 && (ev.getKeyCode() == 19 || ev.getKeyCode() == 3)) {
            Object source = ev.getSource();
            if (source instanceof Component) {
                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                System.err.println("*** ShortcutAndMenuKeyEventProcessor: current focus owner = " + focused);
            }
            ev.consume();
            return true;
        }
        if (ev.getID() == 400 && this.skipNextTyped) {
            ev.consume();
            this.skipNextTyped = false;
            return true;
        }
        if (ev.getID() == 402) {
            this.skipNextTyped = false;
        }
        if (ev.getID() == 401) {
            this.lastKeyChar = ev.getKeyChar();
            this.lastModifiers = ev.getModifiers();
            this.lastSampled = true;
        }
        if ((arr = MenuSelectionManager.defaultManager().getSelectedPath()) == null || arr.length == 0) {
            this.wasPopupDisplayed = false;
            return KeyboardPopupSwitcher.processShortcut(ev);
        }
        if (!this.wasPopupDisplayed && this.lastSampled && ev.getID() == 400 && this.lastModifiers == 8 && ev.getModifiers() == 8 && this.lastKeyChar == ev.getKeyChar()) {
            this.wasPopupDisplayed = true;
            ev.consume();
            return true;
        }
        this.wasPopupDisplayed = true;
        MenuSelectionManager.defaultManager().processKeyEvent(ev);
        return ev.isConsumed();
    }

    private boolean processShortcut(KeyEvent ev) {
        if (NbLifecycleManager.isExiting()) {
            ev.consume();
            return true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(ev);
        Window w = SwingUtilities.windowForComponent(ev.getComponent());
        if (w instanceof JFrame && ((JFrame)w).getRootPane().getClientProperty("netbeans.helpframe") != null) {
            return true;
        }
        if (w instanceof Dialog && !WindowManagerImpl.isSeparateWindow(w) && !ShortcutAndMenuKeyEventProcessor.isTransmodalAction(ks)) {
            return false;
        }
        ActionEvent aev = new ActionEvent(ev.getSource(), 1001, Utilities.keyToString((KeyStroke)ks));
        Keymap root = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        Action a = root.getAction(ks);
        if (a != null && a.isEnabled()) {
            ActionManager am = (ActionManager)Lookup.getDefault().lookup(ActionManager.class);
            am.invokeAction(a, aev);
            ev.consume();
            return true;
        }
        return false;
    }

    private void processMouseEvent(MouseEvent mev) {
        if (mev.getID() != 501 || mev.getButton() <= 3 || mev.isPopupTrigger() || mev.isConsumed()) {
            return;
        }
        int button = mev.getButton();
        if (Utilities.getOperatingSystem() == 16 && (button -= 2) <= 3) {
            return;
        }
        if (NbLifecycleManager.isExiting()) {
            return;
        }
        int keycode = Utilities.mouseButtonKeyCode((int)button);
        if (keycode == 0) {
            return;
        }
        int modifiers = 0;
        if (mev.isControlDown()) {
            modifiers |= 0x80;
        }
        if (mev.isAltDown()) {
            modifiers |= 0x200;
        }
        if (mev.isShiftDown()) {
            modifiers |= 0x40;
        }
        if (mev.isMetaDown()) {
            modifiers |= 0x100;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(keycode, modifiers);
        Window w = SwingUtilities.windowForComponent(mev.getComponent());
        if (w instanceof JFrame && ((JFrame)w).getRootPane().getClientProperty("netbeans.helpframe") != null) {
            return;
        }
        if (w instanceof Dialog && !WindowManagerImpl.isSeparateWindow(w) && !ShortcutAndMenuKeyEventProcessor.isTransmodalAction(ks)) {
            return;
        }
        ActionEvent aev = new ActionEvent(mev.getSource(), 1001, Utilities.keyToString((KeyStroke)ks));
        Action action = null;
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused instanceof JTextComponent) {
            action = ((JTextComponent)focused).getKeymap().getAction(ks);
        }
        if (action == null) {
            Keymap km = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            Action action2 = action = km != null ? km.getAction(ks) : null;
        }
        if (action != null && action.isEnabled()) {
            action.actionPerformed(aev);
            mev.consume();
        }
    }

    private static boolean invokeProcessKeyBindingsForAllComponents(KeyEvent e, Container container, boolean pressed) {
        try {
            Method m = JComponent.class.getDeclaredMethod("processKeyBindingsForAllComponents", KeyEvent.class, Container.class, Boolean.TYPE);
            if (m == null) {
                return false;
            }
            m.setAccessible(true);
            Boolean b = (Boolean)m.invoke(null, e, container, pressed ? Boolean.TRUE : Boolean.FALSE);
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTransmodalAction(KeyStroke key) {
        Keymap root = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        Action a = root.getAction(key);
        if (a == null) {
            return false;
        }
        Object val = a.getValue("OpenIDE-Transmodal-Action");
        return val != null && val.equals(Boolean.TRUE);
    }

    static {
        installed = false;
        log = Logger.getLogger("org.netbeans.core.windows.ShortcutAndMenuKeyEventProcessor");
    }
}

