/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.openide.util.NbBundle;

final class OverriddenAbsMethodFinder
implements CancellableTask<CompilationController> {
    private final HashSet<ElementHandle<ExecutableElement>> allMethods;
    private Problem problem;

    OverriddenAbsMethodFinder(HashSet<ElementHandle<ExecutableElement>> allMethods) {
        this.allMethods = allMethods;
    }

    public void cancel() {
    }

    public void run(CompilationController javac) throws Exception {
        for (ElementHandle<ExecutableElement> method : this.allMethods) {
            ExecutableElement el = (ExecutableElement)method.resolve((CompilationInfo)javac);
            Collection<ExecutableElement> overriddenMethods = JavaRefactoringUtils.getOverriddenMethods(el, (CompilationInfo)javac);
            for (ExecutableElement overriddenMethod : overriddenMethods) {
                ElementHandle handle = ElementHandle.create((Element)overriddenMethod);
                if (this.allMethods.contains(handle)) continue;
                TypeElement type1 = javac.getElementUtilities().enclosingTypeElement((Element)el);
                TypeElement type2 = javac.getElementUtilities().enclosingTypeElement((Element)overriddenMethod);
                Problem prob = new Problem(false, NbBundle.getMessage(OverriddenAbsMethodFinder.class, (String)"WRN_Implements", (Object)overriddenMethod.getSimpleName(), (Object)type1.getQualifiedName(), (Object)type2.getQualifiedName()));
                this.problem = JavaPluginUtils.chainProblems(this.problem, prob);
            }
        }
    }

    public Problem getProblem() {
        return this.problem;
    }
}

