/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.ExecutionEvent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.execute.CommandLineOutputHandler;
import org.netbeans.modules.maven.execute.cmd.ExecutionEventObject;
import org.netbeans.modules.maven.output.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColors;
import org.openide.windows.IOPosition;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class GlobalOutputProcessor
implements OutputProcessor {
    private static final String SECTION_SESSION = "session-execute";
    private static final Pattern LOW_MVN = Pattern.compile("(.*)Error resolving version for (.*): Plugin requires Maven version (.*)");
    private static final Pattern HELP = Pattern.compile("(?:\\[ERROR\\] )?\\[Help \\d+\\] (https?://.+)");
    static final Pattern MODEL_PROBLEM = Pattern.compile(".+ @ (?:\\S+, (.+), )?line (\\d+), column (\\d+)");
    static final Pattern MODEL_PROBLEM2 = Pattern.compile(".*Non-parseable POM (.+)pom.xml: .* @ (.*pom.xml)?,? ?line (\\d+), column (\\d+) .*");
    private static final Logger LOG = Logger.getLogger(GlobalOutputProcessor.class.getName());
    private final RunConfig config;
    private boolean processReactorSummary = false;
    private Iterator<ExecutionEventObject.Tree> projectIterator;

    GlobalOutputProcessor(RunConfig config) {
        this.config = config;
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return new String[]{SECTION_SESSION};
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher m3;
        if (CommandLineOutputHandler.startPatternM3.matcher("[INFO] " + line).matches()) {
            visitor.setOutputType(IOColors.OutputType.LOG_DEBUG);
            return;
        }
        if (line.startsWith("BUILD ")) {
            if (line.startsWith("BUILD SUCCESS")) {
                visitor.setOutputType(IOColors.OutputType.LOG_SUCCESS);
                return;
            }
            if (line.startsWith("BUILD FAILURE")) {
                visitor.setOutputType(IOColors.OutputType.LOG_FAILURE);
                return;
            }
        }
        if (line.startsWith("Reactor Summary") && line.endsWith(":")) {
            this.processReactorSummary = true;
            CommandLineOutputHandler.ContextImpl context = (CommandLineOutputHandler.ContextImpl)visitor.getContext();
            if (context != null) {
                this.projectIterator = context.getExecutionTree().getChildrenNodes().iterator();
            }
            return;
        }
        if (this.processReactorSummary && this.projectIterator != null && CommandLineOutputHandler.reactorSummaryLine.matcher(line).matches() && this.projectIterator.hasNext()) {
            final ExecutionEventObject.Tree next = this.projectIterator.next();
            boolean projectFailed = next.getEndEvent() != null ? ExecutionEvent.Type.ProjectFailed.equals((Object)next.getEndEvent().type) : false;
            boolean lineFailed = line.contains(" FAILURE ");
            if (lineFailed != projectFailed) {
                LOG.log(Level.INFO, "Maven Project Reactor summary out of sync for:" + line);
            } else if (projectFailed) {
                visitor.setOutputListener(new OutputListener(){

                    public void outputLineAction(OutputEvent ev) {
                        RequestProcessor.getDefault().post(() -> ((IOPosition.Position)next.getEndOffset()).scrollTo());
                    }
                });
            }
        }
        if (LOW_MVN.matcher(line).matches()) {
            visitor.setLine(line + "\n" + Bundle.TXT_ChangeSettings());
            visitor.setOutputType(IOColors.OutputType.LOG_FAILURE);
            visitor.setOutputListener(new OutputListener(){

                public void outputLineAction(OutputEvent ev) {
                    OptionsDisplayer.getDefault().open("Java/Maven");
                }
            });
            return;
        }
        final Matcher m = HELP.matcher(line);
        if (m.matches()) {
            visitor.setOutputListener(new OutputListener(){

                public void outputLineAction(OutputEvent ev) {
                    try {
                        HtmlBrowser.URLDisplayer.getDefault().showURLExternal(new URI(m.group(1)).toURL());
                    }
                    catch (MalformedURLException | URISyntaxException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
            });
            return;
        }
        Matcher m2 = MODEL_PROBLEM.matcher(line);
        if (m2.matches()) {
            visitor.setOutputListener(new OL(m2.group(1), Integer.parseInt(m2.group(2)), Integer.parseInt(m2.group(3)), this.config));
        }
        if ((m3 = MODEL_PROBLEM2.matcher(line)).matches()) {
            Object loc = m3.group(2) != null ? m3.group(2) : m3.group(1) + "pom.xml";
            visitor.setOutputListener(new OL((String)loc, Integer.parseInt(m3.group(3)), Integer.parseInt(m3.group(4)), this.config));
        }
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class OL
    implements OutputListener {
        private final int column;
        private final int line;
        private final String loc;
        private final RunConfig config;

        public OL(String loc, int line, int column, RunConfig config) {
            this.loc = loc;
            this.line = line;
            this.column = column;
            this.config = config;
        }

        public void outputLineAction(OutputEvent ev) {
            DataObject pomDO;
            File pom = this.loc == null ? new File(this.config.getExecutionDirectory(), "pom.xml") : FileUtilities.convertStringToFile(this.loc);
            FileObject pomFO = FileUtil.toFileObject((File)pom);
            if (pomFO == null) {
                LOG.log(Level.WARNING, "no such file: {0}", pom);
                return;
            }
            try {
                pomDO = DataObject.find((FileObject)pomFO);
            }
            catch (DataObjectNotFoundException x) {
                LOG.log(Level.INFO, null, x);
                return;
            }
            LineCookie lc = (LineCookie)pomDO.getLookup().lookup(LineCookie.class);
            if (lc == null) {
                LOG.log(Level.WARNING, "no LineCookie in {0}", pom);
                return;
            }
            try {
                lc.getLineSet().getOriginal(this.line - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, this.column - 1);
            }
            catch (IndexOutOfBoundsException x) {
                LOG.log(Level.WARNING, "no such line {0} in {1}: {2}", new Object[]{this.line, pom, x});
            }
        }
    }
}

