/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.state;

import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.data.PayaraStatusCheck;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.state.StatusJob;
import org.netbeans.modules.payara.tooling.server.state.StatusJobState;

public abstract class AbstractTask
implements Runnable {
    private static final Logger LOGGER = new Logger(AbstractTask.class);
    final StatusJob job;
    final StatusJob.Task task;
    final StatusJobState jobState;
    final PayaraStatusCheck type;
    final TaskStateListener[] stateListeners;
    boolean cancelled;

    AbstractTask(StatusJob job, StatusJob.Task task, PayaraStatusCheck type) {
        this.job = job;
        this.task = task;
        this.jobState = job.getState();
        this.type = type;
        this.stateListeners = task.getListeners();
        this.cancelled = false;
    }

    void cancel() {
        this.cancelled = true;
    }

    void handleStateChange(TaskState taskState, TaskEvent taskEvent, String ... args) {
        if (this.stateListeners != null && !this.cancelled) {
            for (int i = 0; i < this.stateListeners.length; ++i) {
                if (this.stateListeners[i] == null) continue;
                this.stateListeners[i].operationStateChanged(taskState, taskEvent, args);
            }
        }
    }
}

