/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.context.Context;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.filters.FilterChoice;
import tr.view.filters.ContextAll;
import tr.view.filters.ContextMultiple;
import tr.view.filters.ContextMultipleEdit;
import tr.view.filters.FilterComboAbstract;
import tr.view.filters.MultiChoiceDialog;

public class FilterContext
extends FilterChoice
implements PropertyChangeListener {
    public static final byte INDEX = 2;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");

    public FilterContext() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new ContextsCombo();
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Context context = (Context)this.combo.getSelectedItem();
        if (context == null) {
            this.fireMatchAll();
        } else if (context instanceof ContextAll) {
            this.fireMatchAll();
        } else if (context instanceof ContextMultiple) {
            ContextMultiple m = (ContextMultiple)context;
            this.fireChanged(new ContextMatcher(m.getChosen()));
        } else {
            this.fireChanged(new ContextMatcher(context));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-context");
    }

    public byte getIndex() {
        return 2;
    }

    public String[] getSerialValues() {
        if (this.combo == null) {
            return null;
        }
        Context context = (Context)this.combo.getSelectedItem();
        if (context == null) {
            return null;
        }
        if (context instanceof ContextAll) {
            return new String[]{"all"};
        }
        if (context instanceof ContextMultiple) {
            Vector chosen = ((ContextMultiple)context).getChosen();
            if (chosen == null || chosen.size() == 0) {
                return null;
            }
            Vector<String> values = new Vector<String>();
            for (Context c : chosen) {
                if (c == null) continue;
                values.add(c.getName());
            }
            return values.toArray(new String[0]);
        }
        return new String[]{context.getName()};
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            if (values[0].equals("all")) {
                this.combo.setSelectedIndex(0);
            } else {
                this.combo.setSelectedItem((Object)this.getContext(values[0]));
            }
        } else if (values.length > 1) {
            Object o = this.combo.getItemAt(1);
            if (o instanceof ContextMultiple) {
                ContextMultiple multiple = (ContextMultiple)o;
                Vector<Context> chosen = new Vector<Context>();
                for (String name : values) {
                    Context context = this.getContext(name);
                    if (context == null) continue;
                    chosen.add(context);
                }
                multiple.setChosen(chosen);
            }
            this.combo.setSelectedIndex(1);
        }
        this.combo.startChangeEvents();
    }

    private Context getContext(String name) {
        if (name == null) {
            return null;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        Manager contextManager = data.getContextManager();
        for (Context context : contextManager.list()) {
            if (!context.getName().equals(name)) continue;
            return context;
        }
        return null;
    }

    protected boolean canExcludeNulls() {
        return false;
    }

    public class ContextsCombo
    extends FilterComboAbstract {
        private final ActionListener listener;
        private Object lastSelectedItem;

        public ContextsCombo() {
            super((ComboBoxModel)new ContextsComboBoxModel());
            this.listener = !Utilities.isMac() ? new WindowsActionListener() : new RealActionListener();
            this.addActionListener(this.listener);
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
            this.lastSelectedItem = this.getSelectedItem();
        }

        public JComboBox getJComboBox() {
            return this;
        }

        private final class WindowsActionListener
        implements ActionListener {
            private WindowsActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = ContextsCombo.this.getSelectedItem();
                if (object instanceof ContextMultipleEdit) {
                    ContextsComboBoxModel model = (ContextsComboBoxModel)ContextsCombo.this.getModel();
                    ContextMultiple m = model.contextMultiple;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getContextManager().list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)ContextsCombo.this), all, m.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-context"));
                    d.setLocationRelativeTo((Component)((Object)ContextsCombo.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        m.setChosen(d.getChosen());
                        ContextsCombo.this.setSelectedItem(m);
                        ContextsCombo.this.lastSelectedItem = m;
                    } else {
                        ContextsCombo.this.setSelectedItem(ContextsCombo.this.lastSelectedItem);
                    }
                } else {
                    ContextsCombo.this.lastSelectedItem = object;
                }
                ContextsCombo.this.fireValueChange();
            }
        }

        private final class RealActionListener
        implements ActionListener {
            private RealActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = ContextsCombo.this.getSelectedItem();
                if (object instanceof ContextMultiple) {
                    ContextMultiple m = (ContextMultiple)object;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getContextManager().list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)ContextsCombo.this), all, m.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-context"));
                    d.setLocationRelativeTo((Component)((Object)ContextsCombo.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        m.setChosen(d.getChosen());
                    }
                }
                ContextsCombo.this.fireValueChange();
            }
        }
    }

    private class ContextsComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        private final ContextAll contextAll = new ContextAll();
        private final ContextMultiple contextMultiple = new ContextMultiple();
        private final ContextMultipleEdit contextMultipleEdit = new ContextMultipleEdit();
        private Manager<Context> contextManager;
        private List<Context> contexts;
        private Lookup.Result result;

        public ContextsComboBoxModel() {
            this.initialise();
        }

        private void initialise() {
            Data data;
            if (this.contextManager != null) {
                this.contextManager.removeObserver((Observer)this);
            }
            if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
                this.contextManager = null;
                this.contexts = new Vector<Context>();
            } else {
                this.contextManager = data.getContextManager();
                this.contextManager.addObserver((Observer)this);
                this.contexts = this.contextManager.list();
                Collections.sort(this.contexts);
            }
            this.contexts.add(0, (Context)this.contextAll);
            this.contexts.add(1, (Context)this.contextMultiple);
            if (!Utilities.isMac()) {
                this.contexts.add(2, (Context)this.contextMultipleEdit);
            }
            if (this.result == null) {
                this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        ContextsComboBoxModel.this.update(null, null);
                    }
                });
            }
        }

        public Object getElementAt(int index) {
            return this.contexts.get(index);
        }

        public int getSize() {
            return this.contexts.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextMatcher
    implements Matcher<Action> {
        private final boolean all;
        private final List<Context> contexts;

        public ContextMatcher() {
            this.all = true;
            this.contexts = null;
        }

        public ContextMatcher(Context context) {
            this.all = false;
            this.contexts = new Vector<Context>();
            this.contexts.add(context);
        }

        public ContextMatcher(List<Context> contexts) {
            this.all = false;
            this.contexts = contexts;
        }

        public boolean matches(Action action) {
            if (this.all) {
                return true;
            }
            for (Context context : this.contexts) {
                if (!action.getContext().equals((Object)context)) continue;
                return true;
            }
            return false;
        }
    }
}

