/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.testutil;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class CountingPropertyChangeListener
implements PropertyChangeListener {
    private Map<String, Integer> propertyChangeCounts = new HashMap<String, Integer>();
    private int propertyChangeCount;
    private String lastPropertyChange;
    private Object lastSource;
    private Object lastOldValue;
    private Object lastNewValue;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ++this.propertyChangeCount;
        this.lastPropertyChange = evt.getPropertyName();
        this.lastSource = evt.getSource();
        this.lastOldValue = evt.getOldValue();
        this.lastNewValue = evt.getNewValue();
        Integer oldCount = this.propertyChangeCounts.get(evt.getPropertyName());
        if (oldCount == null) {
            oldCount = 0;
        }
        this.propertyChangeCounts.put(evt.getPropertyName(), oldCount + 1);
    }

    public Object getLastNewValue() {
        return this.lastNewValue;
    }

    public Object getLastOldValue() {
        return this.lastOldValue;
    }

    public String getLastPropertyChange() {
        return this.lastPropertyChange;
    }

    public Object getLastSource() {
        return this.lastSource;
    }

    public int getPropertyChangeCount() {
        return this.propertyChangeCount;
    }

    public int getPropertyChangeCount(String propName) {
        Integer count = this.propertyChangeCounts.get(propName);
        if (count == null) {
            return 0;
        }
        return count;
    }
}

