/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.EOFException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.HandlerImpl;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.SubSession;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.Lease2;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLease;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.RequestLeaseSetMessage;

class RequestLeaseSetMessageHandler
extends HandlerImpl {
    private final Map<Destination, LeaseInfo> _existingLeaseSets = new ConcurrentHashMap<Destination, LeaseInfo>(4);
    protected int _ls2Type = 3;
    private static final String PROP_LS_ENCRYPT = "i2cp.encryptLeaseSet";
    private static final String PROP_LS_KEY = "i2cp.leaseSetKey";
    private static final String PROP_LS_PK = "i2cp.leaseSetPrivateKey";
    private static final String PROP_LS_SPK = "i2cp.leaseSetSigningPrivateKey";
    public static final String PROP_LS_TYPE = "i2cp.leaseSetType";
    private static final String PROP_LS_ENCTYPE = "i2cp.leaseSetEncType";
    private static final String PROP_SECRET = "i2cp.leaseSetSecret";
    private static final String PROP_AUTH_TYPE = "i2cp.leaseSetAuthType";
    private static final String PROP_PRIV_KEY = "i2cp.leaseSetPrivKey";
    private static final String PROP_DH = "i2cp.leaseSetClient.dh.";
    private static final String PROP_PSK = "i2cp.leaseSetClient.psk.";
    private static final boolean PREFER_NEW_ENC = true;

    public RequestLeaseSetMessageHandler(I2PAppContext context) {
        this(context, 21);
    }

    protected RequestLeaseSetMessageHandler(I2PAppContext context, int messageType) {
        super(context, messageType);
    }

    protected boolean requiresLS2(I2PSessionImpl session) {
        if (!session.supportsLS2()) {
            return false;
        }
        String s = session.getOptions().getProperty(PROP_LS_TYPE);
        if (s != null) {
            try {
                int type;
                this._ls2Type = type = Integer.parseInt(s);
                if (type != 1) {
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                session.propogateError("Bad LS2 type", nfe);
                session.destroySession();
                return true;
            }
        }
        if (session.isOffline()) {
            return true;
        }
        s = session.getOptions().getProperty(PROP_LS_ENCTYPE);
        return s != null && !s.equals("0") && !s.equals("ELGAMAL_2048");
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        LeaseSet leaseSet;
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        RequestLeaseSetMessage msg = (RequestLeaseSetMessage)message;
        boolean isLS2 = this.requiresLS2(session);
        if (isLS2) {
            LeaseSet2 ls2;
            if (this._ls2Type == 3) {
                ls2 = new LeaseSet2();
            } else if (this._ls2Type == 5) {
                ls2 = new EncryptedLeaseSet();
            } else if (this._ls2Type == 7) {
                ls2 = new MetaLeaseSet();
            } else {
                session.propogateError("Unsupported LS2 type", new Exception());
                session.destroySession();
                return;
            }
            if (Boolean.parseBoolean(session.getOptions().getProperty("i2cp.dontPublishLeaseSet"))) {
                ls2.setUnpublished();
            }
            long now = Math.max(this._context.clock().now(), session.getLastLS2SignTime() + 1000L);
            ls2.setPublished(now);
            session.setLastLS2SignTime(now);
            leaseSet = ls2;
        } else {
            leaseSet = new LeaseSet();
        }
        for (int i = 0; i < msg.getEndpoints(); ++i) {
            Lease lease;
            if (this._ls2Type == 7) {
                lease = new MetaLease();
            } else if (isLS2) {
                lease = new Lease2();
                lease.setTunnelId(msg.getTunnelId(i));
            } else {
                lease = new Lease();
                lease.setTunnelId(msg.getTunnelId(i));
            }
            lease.setGateway(msg.getRouter(i));
            lease.setEndDate(msg.getEndDate().getTime());
            leaseSet.addLease(lease);
        }
        this.signLeaseSet(leaseSet, isLS2, session);
    }

    protected synchronized void signLeaseSet(LeaseSet leaseSet, boolean isLS2, I2PSessionImpl session) {
        long exp;
        LeaseSet2 ls2;
        boolean ok;
        String secret;
        if (isLS2 && this._ls2Type == 5 && (secret = session.getOptions().getProperty(PROP_SECRET)) != null) {
            EncryptedLeaseSet encls2 = (EncryptedLeaseSet)leaseSet;
            secret = DataHelper.getUTF8(Base64.decode(secret));
            encls2.setSecret(secret);
        }
        Destination dest = session.getMyDestination();
        leaseSet.setDestination(dest);
        LeaseInfo li = this._existingLeaseSets.get(dest);
        if (li == null) {
            ArrayList<EncType> types = new ArrayList<EncType>(2);
            Object senc = session.getOptions().getProperty(PROP_LS_ENCTYPE);
            if (senc != null) {
                String[] senca;
                if (((String)senc).equals("0,4")) {
                    senc = "4,0";
                }
                for (String sencaa : senca = DataHelper.split((String)senc, ",")) {
                    EncType newtype = EncType.parseEncType(sencaa);
                    if (newtype != null) {
                        if (types.contains((Object)newtype)) {
                            this._log.error("Duplicate crypto type: " + (Object)((Object)newtype));
                            continue;
                        }
                        if (newtype.isAvailable()) {
                            types.add(newtype);
                            continue;
                        }
                        this._log.error("Unsupported crypto type: " + (Object)((Object)newtype));
                        continue;
                    }
                    this._log.error("Unsupported crypto type: " + sencaa);
                }
            }
            if (types.isEmpty()) {
                types.add(EncType.ELGAMAL_2048);
            }
            String spk = session.getOptions().getProperty(PROP_LS_PK);
            String sspk = isLS2 ? null : session.getOptions().getProperty(PROP_LS_SPK);
            ArrayList<PrivateKey> privKeys = new ArrayList<PrivateKey>(2);
            SigningPrivateKey signingPrivKey = null;
            if (spk != null && (isLS2 || sspk != null)) {
                boolean useOldKeys = true;
                if (!isLS2) {
                    int colon = sspk.indexOf(58);
                    SigType type = dest.getSigType();
                    if (colon > 0) {
                        String stype = sspk.substring(0, colon);
                        SigType t = SigType.parseSigType(stype);
                        if (t == type) {
                            sspk = sspk.substring(colon + 1);
                        } else {
                            useOldKeys = false;
                        }
                    }
                    if (useOldKeys) {
                        try {
                            signingPrivKey = new SigningPrivateKey(type);
                            signingPrivKey.fromBase64(sspk);
                        }
                        catch (DataFormatException dfe) {
                            useOldKeys = false;
                            signingPrivKey = null;
                        }
                    }
                }
                if (useOldKeys) {
                    this.parsePrivateKeys(spk, privKeys, types);
                }
            }
            if (privKeys.isEmpty() && !this._existingLeaseSets.isEmpty()) {
                PublicKey pk = dest.getPublicKey();
                for (Map.Entry<Destination, LeaseInfo> e : this._existingLeaseSets.entrySet()) {
                    if (!pk.equals(e.getKey().getPublicKey())) continue;
                    privKeys.addAll(e.getValue().getPrivateKeys());
                    if (!this._log.shouldInfo()) break;
                    this._log.info("Creating leaseInfo for " + dest.toBase32() + " with private key from " + e.getKey().toBase32());
                    break;
                }
            }
            if (!privKeys.isEmpty()) {
                if (signingPrivKey != null) {
                    li = new LeaseInfo(privKeys, signingPrivKey);
                    if (this._log.shouldInfo()) {
                        this._log.info("Creating leaseInfo for " + dest.toBase32() + " LS1 WITH configured private keys");
                    }
                } else if (isLS2) {
                    li = new LeaseInfo(privKeys);
                    if (this._log.shouldInfo()) {
                        this._log.info("Creating leaseInfo for " + dest.toBase32() + " LS2 WITH configured private keys");
                    }
                } else {
                    li = new LeaseInfo(privKeys, dest);
                    if (this._log.shouldInfo()) {
                        this._log.info("Creating leaseInfo for " + dest.toBase32() + " LS1 WITH configured private keys and new revocation key");
                    }
                }
            } else {
                li = new LeaseInfo(dest, types, isLS2);
                if (this._log.shouldInfo()) {
                    this._log.info("Creating leaseInfo for " + dest.toBase32() + " without configured private keys");
                }
            }
            this._existingLeaseSets.put(dest, li);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Caching the old leaseInfo keys for " + dest.toBase32());
        }
        if (isLS2) {
            LeaseSet2 ls22 = (LeaseSet2)leaseSet;
            if (this._ls2Type != 7) {
                for (PublicKey key : li.getPublicKeys()) {
                    ls22.addEncryptionKey(key);
                }
            }
        } else {
            leaseSet.setEncryptionKey(li.getPublicKey());
            leaseSet.setSigningKey(li.getSigningPublicKey());
        }
        Properties opts = session instanceof SubSession ? ((SubSession)session).getPrimaryOptions() : session.getOptions();
        boolean encrypt = Boolean.parseBoolean(opts.getProperty(PROP_LS_ENCRYPT));
        String sk = opts.getProperty(PROP_LS_KEY);
        Hash h = dest.calculateHash();
        if (encrypt && sk != null) {
            SessionKey key = new SessionKey();
            try {
                key.fromBase64(sk);
                leaseSet.encrypt(key);
                this._context.keyRing().put(h, key);
            }
            catch (DataFormatException dfe) {
                this._log.error("Bad leaseset key: " + sk);
                this._context.keyRing().remove(h);
            }
        } else {
            this._context.keyRing().remove(h);
        }
        if (session.isOffline() && !(ok = (ls2 = (LeaseSet2)leaseSet).setOfflineSignature(exp = session.getOfflineExpiration(), session.getTransientSigningPublicKey(), session.getOfflineSignature()))) {
            String s = exp <= this._context.clock().now() ? "Offline signature for tunnel expired " + DataHelper.formatTime(exp) : "Bad offline signature";
            session.propogateError(s, new Exception());
            session.destroySession();
        }
        try {
            if (isLS2 && this._ls2Type == 5) {
                byte[] b;
                String p;
                String pfx;
                EncryptedLeaseSet els2 = (EncryptedLeaseSet)leaseSet;
                String at = opts.getProperty(PROP_AUTH_TYPE, "0");
                if (at.equals("1")) {
                    int authType = 1;
                    ArrayList<PublicKey> clientKeys = new ArrayList<PublicKey>(4);
                    pfx = PROP_DH;
                    p = opts.getProperty(PROP_PRIV_KEY);
                    if (p == null) {
                        this._log.error("No i2cp.leaseSetPrivKey for DH auth");
                    } else {
                        b = Base64.decode(p);
                        try {
                            PrivateKey pk = new PrivateKey(EncType.ECIES_X25519, b);
                            clientKeys.add(pk.toPublic());
                        }
                        catch (IllegalArgumentException iae) {
                            this._log.error("Bad priv key: " + p, iae);
                        }
                    }
                    int i = 0;
                    while ((p = opts.getProperty(pfx + i)) != null) {
                        int colon = p.indexOf(58);
                        if (colon >= 0) {
                            p = p.substring(colon + 1);
                        }
                        byte[] b2 = Base64.decode(p);
                        try {
                            PublicKey pk = new PublicKey(EncType.ECIES_X25519, b2);
                            clientKeys.add(pk);
                        }
                        catch (IllegalArgumentException iae) {
                            this._log.error("Bad client key: " + p, iae);
                        }
                        ++i;
                    }
                    els2.sign(session.getPrivateKey(), authType, clientKeys);
                } else if (at.equals("2")) {
                    int authType = 3;
                    ArrayList<PrivateKey> clientKeys = new ArrayList<PrivateKey>(4);
                    pfx = PROP_PSK;
                    p = opts.getProperty(PROP_PRIV_KEY);
                    if (p == null) {
                        this._log.error("No i2cp.leaseSetPrivKey for PSK auth");
                    } else {
                        b = Base64.decode(p);
                        try {
                            PrivateKey pk = new PrivateKey(EncType.ECIES_X25519, b);
                            clientKeys.add(pk);
                        }
                        catch (IllegalArgumentException iae) {
                            this._log.error("Bad priv key: " + p, iae);
                        }
                    }
                    int i = 0;
                    while ((p = opts.getProperty(pfx + i)) != null) {
                        int colon = p.indexOf(58);
                        if (colon >= 0) {
                            p = p.substring(colon + 1);
                        }
                        byte[] b3 = Base64.decode(p);
                        try {
                            PrivateKey pk = new PrivateKey(EncType.ECIES_X25519, b3);
                            clientKeys.add(pk);
                        }
                        catch (IllegalArgumentException iae) {
                            this._log.error("Bad client key: " + p, iae);
                        }
                        ++i;
                    }
                    els2.sign(session.getPrivateKey(), authType, clientKeys);
                } else {
                    els2.sign(session.getPrivateKey());
                }
            } else {
                leaseSet.sign(session.getPrivateKey());
            }
            SigningPrivateKey spk = li.getSigningPrivateKey();
            if (isLS2) {
                spk = null;
            } else if (!this._context.isRouterContext() && spk.getType() != SigType.DSA_SHA1) {
                byte[] dummy = new byte[SigningPrivateKey.KEYSIZE_BYTES];
                this._context.random().nextBytes(dummy);
                spk = new SigningPrivateKey(dummy);
                if (this._log.shouldDebug()) {
                    this._log.debug("Generated random dummy SPK " + spk);
                }
            }
            session.getProducer().createLeaseSet(session, leaseSet, spk, li.getPrivateKeys());
            session.setLeaseSet(leaseSet);
            if (this._log.shouldDebug()) {
                this._log.debug("Created and signed LeaseSet: " + leaseSet);
            }
        }
        catch (DataFormatException dfe) {
            session.propogateError("Error signing the leaseSet", dfe);
            session.destroySession();
        }
        catch (I2PSessionException ise) {
            if (session.isClosed()) {
                EOFException eof = new EOFException("Session closed while signing leaseset");
                eof.initCause(ise);
                session.propogateError("Session closed while signing leaseset", eof);
            }
            session.propogateError("Error sending the signed leaseSet", ise);
        }
    }

    private void parsePrivateKeys(String spkl, List<PrivateKey> privKeys, List<EncType> allowedTypes) {
        String[] spks;
        for (String spk : spks = DataHelper.split(spkl, ",")) {
            PrivateKey privKey;
            EncType type;
            int colon = spk.indexOf(58);
            if (colon > 0) {
                type = EncType.parseEncType(spk.substring(0, colon));
                if (type != null) {
                    if (type.isAvailable()) {
                        if (allowedTypes.contains((Object)type)) {
                            try {
                                privKey = new PrivateKey(type);
                                privKey.fromBase64(spk.substring(colon + 1));
                                privKeys.add(privKey);
                            }
                            catch (DataFormatException dfe) {
                                this._log.error("Bad private key: " + spk, dfe);
                            }
                            continue;
                        }
                        if (!this._log.shouldDebug()) continue;
                        this._log.debug("Ignoring private key with unconfigured crypto type: " + (Object)((Object)type));
                        continue;
                    }
                    this._log.error("Unsupported crypto type: " + (Object)((Object)type));
                    continue;
                }
                this._log.error("Unsupported crypto type: " + spk);
                continue;
            }
            if (colon < 0) {
                type = EncType.ELGAMAL_2048;
                if (allowedTypes.contains((Object)type)) {
                    try {
                        privKey = new PrivateKey();
                        privKey.fromBase64(spk);
                        privKeys.add(privKey);
                    }
                    catch (DataFormatException dfe) {
                        this._log.error("Bad private key: " + spk, dfe);
                    }
                    continue;
                }
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Ignoring private key with unconfigured crypto type: " + (Object)((Object)type));
                continue;
            }
            this._log.error("Empty crypto type");
        }
    }

    private static class LeaseInfo {
        private final List<PublicKey> _pubKeys;
        private final List<PrivateKey> _privKeys;
        private final SigningPublicKey _signingPubKey;
        private final SigningPrivateKey _signingPrivKey;

        public LeaseInfo(Destination dest, List<EncType> types, boolean isLS2) {
            if (types.size() > 1) {
                Collections.sort(types, Collections.reverseOrder());
            }
            this._privKeys = new ArrayList<PrivateKey>(types.size());
            this._pubKeys = new ArrayList<PublicKey>(types.size());
            for (EncType type : types) {
                KeyPair encKeys = KeyGenerator.getInstance().generatePKIKeys(type);
                this._pubKeys.add(encKeys.getPublic());
                this._privKeys.add(encKeys.getPrivate());
            }
            if (isLS2) {
                this._signingPubKey = null;
                this._signingPrivKey = null;
            } else {
                SimpleDataStructure[] signKeys;
                try {
                    signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
                }
                catch (GeneralSecurityException gse) {
                    throw new IllegalStateException(gse);
                }
                this._signingPubKey = (SigningPublicKey)signKeys[0];
                this._signingPrivKey = (SigningPrivateKey)signKeys[1];
            }
        }

        public LeaseInfo(List<PrivateKey> privKeys, SigningPrivateKey signingPrivKey) {
            if (privKeys.size() > 1) {
                Collections.sort(privKeys, new PrivKeyComparator());
            }
            this._privKeys = privKeys;
            this._pubKeys = new ArrayList<PublicKey>(privKeys.size());
            for (PrivateKey privKey : privKeys) {
                this._pubKeys.add(KeyGenerator.getPublicKey(privKey));
            }
            this._signingPubKey = KeyGenerator.getSigningPublicKey(signingPrivKey);
            this._signingPrivKey = signingPrivKey;
        }

        public LeaseInfo(List<PrivateKey> privKeys, Destination dest) {
            SimpleDataStructure[] signKeys;
            try {
                signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this._privKeys = privKeys;
            this._pubKeys = new ArrayList<PublicKey>(privKeys.size());
            for (PrivateKey privKey : privKeys) {
                this._pubKeys.add(KeyGenerator.getPublicKey(privKey));
            }
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public LeaseInfo(List<PrivateKey> privKeys) {
            if (privKeys.size() > 1) {
                Collections.sort(privKeys, new PrivKeyComparator());
            }
            this._privKeys = privKeys;
            this._pubKeys = new ArrayList<PublicKey>(privKeys.size());
            for (PrivateKey privKey : privKeys) {
                this._pubKeys.add(KeyGenerator.getPublicKey(privKey));
            }
            this._signingPubKey = null;
            this._signingPrivKey = null;
        }

        public PublicKey getPublicKey() {
            return this._pubKeys.get(0);
        }

        public PrivateKey getPrivateKey() {
            return this._privKeys.get(0);
        }

        public List<PublicKey> getPublicKeys() {
            return this._pubKeys;
        }

        public List<PrivateKey> getPrivateKeys() {
            return this._privKeys;
        }

        public SigningPublicKey getSigningPublicKey() {
            return this._signingPubKey;
        }

        public SigningPrivateKey getSigningPrivateKey() {
            return this._signingPrivKey;
        }

        private static class PrivKeyComparator
        implements Comparator<PrivateKey> {
            private PrivKeyComparator() {
            }

            @Override
            public int compare(PrivateKey l, PrivateKey r) {
                return r.getType().compareTo(l.getType());
            }
        }
    }
}

