/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.gui.datatransfer.ImageTransferable;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.Images;

public class ImageInputFormat
implements InputFormat {
    private ImageHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;

    public ImageInputFormat(ImageHolderFigure imageHolderFigure) {
        this(imageHolderFigure, "PNG", "Portable Network Graphics (PNG)", "png", 2);
    }

    public ImageInputFormat(ImageHolderFigure imageHolderFigure, String string, String string2, String string3, int n) {
        this.prototype = imageHolderFigure;
        this.formatName = string;
        this.description = string2;
        this.fileExtension = string3;
        this.imageType = n;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(File file, Drawing drawing, boolean bl) throws IOException {
        ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
        imageHolderFigure.loadImage(file);
        imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
        if (bl) {
            drawing.removeAllChildren();
            drawing.set(AttributeKeys.CANVAS_WIDTH, imageHolderFigure.getBounds().width);
            drawing.set(AttributeKeys.CANVAS_HEIGHT, imageHolderFigure.getBounds().height);
        }
        drawing.basicAdd(imageHolderFigure);
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    @Override
    public void read(InputStream inputStream, Drawing drawing, boolean bl) throws IOException {
        ImageHolderFigure imageHolderFigure = this.createImageHolder(inputStream);
        if (bl) {
            drawing.removeAllChildren();
            drawing.set(AttributeKeys.CANVAS_WIDTH, imageHolderFigure.getBounds().width);
            drawing.set(AttributeKeys.CANVAS_HEIGHT, imageHolderFigure.getBounds().height);
        }
        drawing.basicAdd(imageHolderFigure);
    }

    public ImageHolderFigure createImageHolder(InputStream inputStream) throws IOException {
        ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
        imageHolderFigure.loadImage(inputStream);
        imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
        return imageHolderFigure;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        try {
            return dataFlavor.equals(DataFlavor.imageFlavor) || dataFlavor.equals(ImageTransferable.IMAGE_PNG_FLAVOR) || dataFlavor.equals(new DataFlavor("application/octet-stream; type=public.png"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public void read(Transferable transferable, Drawing drawing, boolean bl) throws UnsupportedFlavorException, IOException {
        DataFlavor[] dataFlavorArray;
        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                image = Images.toBufferedImage(image);
                ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
                imageHolderFigure.setBufferedImage((BufferedImage)image);
                imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
                LinkedList<ImageHolderFigure> linkedList = new LinkedList<ImageHolderFigure>();
                linkedList.add(imageHolderFigure);
                if (bl) {
                    drawing.removeAllChildren();
                    drawing.set(AttributeKeys.CANVAS_WIDTH, imageHolderFigure.getBounds().width);
                    drawing.set(AttributeKeys.CANVAS_HEIGHT, imageHolderFigure.getBounds().height);
                }
                drawing.addAll(linkedList);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DataFlavor dataFlavor = null;
        try {
            for (DataFlavor dataFlavor2 : dataFlavorArray = new DataFlavor[]{ImageTransferable.IMAGE_PNG_FLAVOR, new DataFlavor("application/octet-stream; type=public.png")}) {
                if (!transferable.isDataFlavorSupported(dataFlavor2)) continue;
                dataFlavor = dataFlavor2;
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (dataFlavor != null) {
            try {
                dataFlavorArray = (DataFlavor[])transferable.getTransferData(dataFlavor);
                BufferedImage bufferedImage2 = ImageIO.read((InputStream)dataFlavorArray);
                bufferedImage2 = Images.toBufferedImage(bufferedImage2);
                ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
                imageHolderFigure.setBufferedImage(bufferedImage2);
                imageHolderFigure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(imageHolderFigure.getBufferedImage().getWidth(), imageHolderFigure.getBufferedImage().getHeight()));
                LinkedList<ImageHolderFigure> linkedList = new LinkedList<ImageHolderFigure>();
                linkedList.add(imageHolderFigure);
                if (bl) {
                    drawing.removeAllChildren();
                    drawing.set(AttributeKeys.CANVAS_WIDTH, imageHolderFigure.getBounds().width);
                    drawing.set(AttributeKeys.CANVAS_HEIGHT, imageHolderFigure.getBounds().height);
                }
                drawing.addAll(linkedList);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                IOException iOException = new IOException("Couldn't import image as image/png flavor");
                iOException.initCause(throwable);
                throw iOException;
            }
        } else {
            throw new IOException("Couldn't import image.");
        }
    }
}

