/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.filterchain;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoEvent;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.FilterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoFilterEvent
extends IoEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoFilterEvent.class);
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final IoFilter.NextFilter nextFilter;

    public IoFilterEvent(IoFilter.NextFilter nextFilter, IoEventType type, IoSession session, Object parameter) {
        super(type, session, parameter);
        if (nextFilter == null) {
            throw new IllegalArgumentException("nextFilter must not be null");
        }
        this.nextFilter = nextFilter;
    }

    public IoFilter.NextFilter getNextFilter() {
        return this.nextFilter;
    }

    @Override
    public void fire() {
        IoSession session = this.getSession();
        IoEventType type = this.getType();
        if (DEBUG) {
            LOGGER.debug("Firing a {} event for session {}", (Object)type, (Object)session.getId());
        }
        switch (type) {
            case CLOSE: {
                this.nextFilter.filterClose(session);
                break;
            }
            case EVENT: {
                this.nextFilter.event(session, (FilterEvent)this.getParameter());
                break;
            }
            case EXCEPTION_CAUGHT: {
                Throwable throwable = (Throwable)this.getParameter();
                this.nextFilter.exceptionCaught(session, throwable);
                break;
            }
            case INPUT_CLOSED: {
                this.nextFilter.inputClosed(session);
                break;
            }
            case MESSAGE_RECEIVED: {
                Object parameter = this.getParameter();
                this.nextFilter.messageReceived(session, parameter);
                break;
            }
            case MESSAGE_SENT: {
                WriteRequest writeRequest = (WriteRequest)this.getParameter();
                this.nextFilter.messageSent(session, writeRequest);
                break;
            }
            case SESSION_CLOSED: {
                this.nextFilter.sessionClosed(session);
                break;
            }
            case SESSION_CREATED: {
                this.nextFilter.sessionCreated(session);
                break;
            }
            case SESSION_IDLE: {
                this.nextFilter.sessionIdle(session, (IdleStatus)this.getParameter());
                break;
            }
            case SESSION_OPENED: {
                this.nextFilter.sessionOpened(session);
                break;
            }
            case WRITE: {
                WriteRequest writeRequest = (WriteRequest)this.getParameter();
                this.nextFilter.filterWrite(session, writeRequest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + (Object)((Object)type));
            }
        }
        if (DEBUG) {
            LOGGER.debug("Event {} has been fired for session {}", (Object)type, (Object)session.getId());
        }
    }
}

