/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Security;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class IaikSignatureAlgosTest
extends TestCase {
    private SignatureValidator validator;

    public IaikSignatureAlgosTest(String string) {
        super(string);
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        string3 = string3 + string2 + "data" + string2 + "at" + string2 + "iaik" + string2 + "ixsil";
        this.validator = new SignatureValidator(new File(string3, "signatureAlgorithms/signatures"));
    }

    public void test_dsaSignature() throws Exception {
        String string = "dSASignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikSignatureAlgosTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_rsaSignature() throws Exception {
        String string = "rSASignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikSignatureAlgosTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_hmacShortSignature() throws Exception {
        String string = "hMACShortSignature.xml";
        try {
            boolean bl = this.validator.validate(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
            IaikSignatureAlgosTest.fail((String)"Expected HMACOutputLength Exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println(xMLSignatureException.getMessage());
        }
    }

    public void test_hmacSignature() throws Exception {
        String string = "hMACSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
        IaikSignatureAlgosTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public static void main(String[] stringArray) throws Exception {
        IaikSignatureAlgosTest iaikSignatureAlgosTest = new IaikSignatureAlgosTest("");
        iaikSignatureAlgosTest.test_dsaSignature();
        iaikSignatureAlgosTest.test_rsaSignature();
        iaikSignatureAlgosTest.test_hmacShortSignature();
        iaikSignatureAlgosTest.test_hmacSignature();
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

