/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.data;

import com.shapesecurity.salvation.data.Base64Value;
import com.shapesecurity.salvation.data.GUID;
import com.shapesecurity.salvation.data.Origin;
import com.shapesecurity.salvation.data.SchemeHostPortTriple;
import com.shapesecurity.salvation.data.URI;
import com.shapesecurity.salvation.directiveValues.HashSource;
import com.shapesecurity.salvation.directiveValues.HostSource;
import com.shapesecurity.salvation.directiveValues.KeywordSource;
import com.shapesecurity.salvation.directiveValues.MediaType;
import com.shapesecurity.salvation.directiveValues.NonceSource;
import com.shapesecurity.salvation.directiveValues.None;
import com.shapesecurity.salvation.directiveValues.SchemeSource;
import com.shapesecurity.salvation.directiveValues.SourceExpression;
import com.shapesecurity.salvation.directives.ChildSrcDirective;
import com.shapesecurity.salvation.directives.ConnectSrcDirective;
import com.shapesecurity.salvation.directives.DefaultSrcDirective;
import com.shapesecurity.salvation.directives.Directive;
import com.shapesecurity.salvation.directives.DirectiveValue;
import com.shapesecurity.salvation.directives.FetchDirective;
import com.shapesecurity.salvation.directives.FontSrcDirective;
import com.shapesecurity.salvation.directives.FormActionDirective;
import com.shapesecurity.salvation.directives.FrameAncestorsDirective;
import com.shapesecurity.salvation.directives.FrameSrcDirective;
import com.shapesecurity.salvation.directives.ImgSrcDirective;
import com.shapesecurity.salvation.directives.ManifestSrcDirective;
import com.shapesecurity.salvation.directives.MediaSrcDirective;
import com.shapesecurity.salvation.directives.NavigateToDirective;
import com.shapesecurity.salvation.directives.ObjectSrcDirective;
import com.shapesecurity.salvation.directives.PluginTypesDirective;
import com.shapesecurity.salvation.directives.PrefetchSrcDirective;
import com.shapesecurity.salvation.directives.ReferrerDirective;
import com.shapesecurity.salvation.directives.ReportToDirective;
import com.shapesecurity.salvation.directives.ReportUriDirective;
import com.shapesecurity.salvation.directives.ScriptSrcAttrDirective;
import com.shapesecurity.salvation.directives.ScriptSrcDirective;
import com.shapesecurity.salvation.directives.ScriptSrcElemDirective;
import com.shapesecurity.salvation.directives.SourceListDirective;
import com.shapesecurity.salvation.directives.StyleSrcAttrDirective;
import com.shapesecurity.salvation.directives.StyleSrcDirective;
import com.shapesecurity.salvation.directives.StyleSrcElemDirective;
import com.shapesecurity.salvation.directives.WorkerSrcDirective;
import com.shapesecurity.salvation.interfaces.Show;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Policy
implements Show {
    private static final Set<SourceExpression> justNone = Collections.singleton(None.INSTANCE);
    @Nonnull
    private final Map<Class<?>, Directive<? extends DirectiveValue>> directives = new LinkedHashMap();
    @Nonnull
    private Origin origin;

    public Policy(@Nonnull Origin origin) {
        this.origin = origin;
    }

    @Nonnull
    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nonnull Origin origin) {
        this.origin = origin;
    }

    public void intersect(@Nonnull Policy other) {
        this.checkForMergeValidity();
        other.checkForMergeValidity();
        this.resolveSelf();
        other.resolveSelf();
        this.expandDefaultSrc();
        other.expandDefaultSrc();
        for (Map.Entry<Class<?>, Directive<DirectiveValue>> entry : other.directives.entrySet()) {
            this.intersectDirectivePrivate(entry.getValue());
        }
        this.optimise();
        other.optimise();
    }

    public void union(@Nonnull Policy other) {
        this.checkForMergeValidity();
        other.checkForMergeValidity();
        this.resolveSelf();
        other.resolveSelf();
        this.expandDefaultSrc();
        other.expandDefaultSrc();
        for (Map.Entry<Class<?>, Directive<DirectiveValue>> entry2 : other.directives.entrySet()) {
            this.unionDirectivePrivate(entry2.getValue());
        }
        this.directives.entrySet().removeIf(entry -> !other.directives.containsKey(entry.getKey()));
        this.optimise();
        other.optimise();
    }

    private void checkForMergeValidity() {
        if (this.directives.containsKey(ReportUriDirective.class)) {
            throw new IllegalArgumentException("Cannot merge policies if either policy contains a report-uri directive.");
        }
        if (this.directives.containsKey(ReportToDirective.class)) {
            throw new IllegalArgumentException("Cannot merge policies if either policy contains a report-to directive.");
        }
        if (this.directives.containsKey(ReferrerDirective.class)) {
            throw new IllegalArgumentException("Cannot merge policies if either policy contains a referrer directive.");
        }
    }

    private void resolveSelf() {
        for (Map.Entry<Class<?>, Directive<DirectiveValue>> entry : this.directives.entrySet()) {
            Directive<? extends DirectiveValue> directive = entry.getValue();
            if (!(directive instanceof SourceListDirective)) continue;
            this.directives.put(entry.getKey(), ((SourceListDirective)directive).resolveSelf(this.origin));
        }
    }

    private void expandDefaultSrc() {
        Set<Directive> expandedDirectives;
        DefaultSrcDirective defaultSrcDirective;
        if (this.directives.containsKey(ScriptSrcDirective.class) && !this.directives.containsKey(ChildSrcDirective.class) && !this.directives.containsKey(WorkerSrcDirective.class)) {
            ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
            Set sources = scriptSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            this.directives.put(WorkerSrcDirective.class, new WorkerSrcDirective(sources));
        }
        if ((defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class)) != null) {
            Set defaultSources = defaultSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            if (!this.directives.containsKey(ScriptSrcDirective.class)) {
                this.directives.put(ScriptSrcDirective.class, new ScriptSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(StyleSrcDirective.class)) {
                this.directives.put(StyleSrcDirective.class, new StyleSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(ImgSrcDirective.class)) {
                this.directives.put(ImgSrcDirective.class, new ImgSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(ChildSrcDirective.class)) {
                this.directives.put(ChildSrcDirective.class, new ChildSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(ConnectSrcDirective.class)) {
                this.directives.put(ConnectSrcDirective.class, new ConnectSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(FontSrcDirective.class)) {
                this.directives.put(FontSrcDirective.class, new FontSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(MediaSrcDirective.class)) {
                this.directives.put(MediaSrcDirective.class, new MediaSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(ObjectSrcDirective.class)) {
                this.directives.put(ObjectSrcDirective.class, new ObjectSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(ManifestSrcDirective.class)) {
                this.directives.put(ManifestSrcDirective.class, new ManifestSrcDirective(defaultSources));
            }
            if (!this.directives.containsKey(PrefetchSrcDirective.class)) {
                this.directives.put(PrefetchSrcDirective.class, new PrefetchSrcDirective(defaultSources));
            }
        }
        if (this.directives.containsKey(ChildSrcDirective.class) && !this.directives.containsKey(FrameSrcDirective.class)) {
            ChildSrcDirective childSrcDirective = this.getDirectiveByType(ChildSrcDirective.class);
            expandedDirectives = Policy.expandDirective(childSrcDirective);
            expandedDirectives.forEach(this::insert);
        }
        if (this.directives.containsKey(ScriptSrcDirective.class)) {
            ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
            expandedDirectives = Policy.expandDirective(scriptSrcDirective);
            expandedDirectives.forEach(this::insert);
        }
        if (this.directives.containsKey(StyleSrcDirective.class)) {
            StyleSrcDirective styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
            expandedDirectives = Policy.expandDirective(styleSrcDirective);
            expandedDirectives.forEach(this::insert);
        }
    }

    private <V extends SourceExpression, T extends Directive<V>> void eliminateRedundantSourceExpression(@Nonnull Set<SourceExpression> defaultSources, Class<T> type) {
        Set values;
        T directive = this.getDirectiveByType(type);
        if (directive != null && (defaultSources.equals(values = (Set)((Directive)directive).values().collect(Collectors.toCollection(LinkedHashSet::new))) || (defaultSources.isEmpty() || defaultSources.equals(justNone)) && (values.isEmpty() || values.equals(justNone)))) {
            this.directives.remove(type);
        }
    }

    public void optimise() {
        DefaultSrcDirective defaultSrcDirective;
        ScriptSrcDirective scriptSrcDirective;
        ChildSrcDirective childSrcDirective;
        Set styleSources;
        StyleSrcDirective styleSrcDirective;
        Set b;
        Set a;
        Set b2;
        Set a2;
        for (Map.Entry<Class<?>, Directive<DirectiveValue>> entry : this.directives.entrySet()) {
            Directive<? extends DirectiveValue> directive = entry.getValue();
            if (!(directive instanceof SourceListDirective)) continue;
            SourceListDirective sourceListDirective = (SourceListDirective)directive;
            Optional<SourceExpression> star = sourceListDirective.values().filter(x -> x instanceof HostSource && ((HostSource)x).isWildcard()).findAny();
            if (star.isPresent()) {
                Set newSources = sourceListDirective.values().filter(x -> !(x instanceof HostSource)).filter(x -> !(x instanceof SchemeSource) || !((SchemeSource)x).matchesNetworkScheme()).filter(x -> x != KeywordSource.UnsafeInline || !sourceListDirective.containsNonceSource() && !sourceListDirective.containsHashSource()).collect(Collectors.toCollection(LinkedHashSet::new));
                newSources.add(star.get());
                this.directives.put(entry.getKey(), sourceListDirective.construct(newSources));
                continue;
            }
            this.directives.put(entry.getKey(), sourceListDirective.bind(dv -> {
                if (dv instanceof HostSource && this.origin instanceof SchemeHostPortTriple && !((HostSource)dv).hasPath() && ((HostSource)dv).matchesOnlyOrigin((SchemeHostPortTriple)this.origin)) {
                    return Collections.singleton(KeywordSource.Self);
                }
                if (dv == None.INSTANCE) {
                    return Collections.emptySet();
                }
                return null;
            }));
        }
        ScriptSrcElemDirective scriptSrcElemDirective = this.getDirectiveByType(ScriptSrcElemDirective.class);
        ScriptSrcAttrDirective scriptSrcAttrDirective = this.getDirectiveByType(ScriptSrcAttrDirective.class);
        WorkerSrcDirective workerSrcDirective = this.getDirectiveByType(WorkerSrcDirective.class);
        if (scriptSrcElemDirective != null && scriptSrcAttrDirective != null && workerSrcDirective != null && (a2 = (Set)scriptSrcElemDirective.values().filter(x -> x != KeywordSource.UnsafeEval).collect(Collectors.toCollection(LinkedHashSet::new))).equals(b2 = (Set)scriptSrcAttrDirective.values().filter(x -> x != KeywordSource.UnsafeEval).collect(Collectors.toCollection(LinkedHashSet::new)))) {
            ScriptSrcDirective scriptSrcDirective2 = this.getDirectiveByType(ScriptSrcDirective.class);
            Set scriptSources = a2;
            if (scriptSrcDirective2 != null && scriptSrcDirective2.contains(KeywordSource.UnsafeEval)) {
                scriptSources.add(KeywordSource.UnsafeEval);
            }
            scriptSrcDirective2 = new ScriptSrcDirective(scriptSources);
            this.directives.put(ScriptSrcDirective.class, scriptSrcDirective2);
            this.directives.remove(ScriptSrcElemDirective.class);
            this.directives.remove(ScriptSrcAttrDirective.class);
        }
        StyleSrcElemDirective styleSrcElemDirective = this.getDirectiveByType(StyleSrcElemDirective.class);
        StyleSrcAttrDirective styleSrcAttrDirective = this.getDirectiveByType(StyleSrcAttrDirective.class);
        if (styleSrcElemDirective != null && styleSrcAttrDirective != null && (a = (Set)styleSrcElemDirective.values().collect(Collectors.toCollection(LinkedHashSet::new))).equals(b = (Set)styleSrcAttrDirective.values().collect(Collectors.toCollection(LinkedHashSet::new)))) {
            styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
            styleSources = a;
            if (styleSrcDirective != null) {
                styleSources.addAll(styleSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            styleSrcDirective = new StyleSrcDirective(styleSources);
            this.directives.put(StyleSrcDirective.class, styleSrcDirective);
            this.directives.remove(StyleSrcElemDirective.class);
            this.directives.remove(StyleSrcAttrDirective.class);
        }
        if ((childSrcDirective = this.getDirectiveByType(ChildSrcDirective.class)) != null) {
            Set childSources = childSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            this.eliminateRedundantSourceExpression(childSources, WorkerSrcDirective.class);
            this.eliminateRedundantSourceExpression(childSources, FrameSrcDirective.class);
        }
        if ((scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class)) != null) {
            Set scriptSources = scriptSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            this.eliminateRedundantSourceExpression(scriptSources, WorkerSrcDirective.class);
            this.eliminateRedundantSourceExpression(scriptSources, ScriptSrcElemDirective.class);
            this.eliminateRedundantSourceExpression(scriptSources, ScriptSrcAttrDirective.class);
        }
        if ((styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class)) != null) {
            styleSources = styleSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            this.eliminateRedundantSourceExpression(styleSources, StyleSrcElemDirective.class);
            this.eliminateRedundantSourceExpression(styleSources, StyleSrcAttrDirective.class);
        }
        if ((defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class)) != null) {
            Set defaultSources = defaultSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            Directive.getFetchDirectives().forEach(x -> this.eliminateRedundantSourceExpression(defaultSources, (Class)x));
            if (this.directives.containsKey(ScriptSrcDirective.class) && this.directives.containsKey(StyleSrcDirective.class)) {
                defaultSources.removeIf(x -> x instanceof NonceSource);
                defaultSrcDirective = new DefaultSrcDirective(defaultSources);
                this.directives.put(DefaultSrcDirective.class, defaultSrcDirective);
            }
            if (Policy.all(Directive.getFetchDirectives(), this.directives::containsKey)) {
                this.directives.remove(DefaultSrcDirective.class);
            }
        }
    }

    private static <A> boolean all(List<A> list, Function<A, Boolean> predicate) {
        for (A a : list) {
            if (predicate.apply(a).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean containsFetchDirective() {
        return this.directives.values().stream().anyMatch(x -> x instanceof FetchDirective);
    }

    public void postProcessOptimisation() {
        StyleSrcDirective styleSrcDirective;
        ScriptSrcDirective scriptSrcDirective;
        DefaultSrcDirective defaultSrcDirective;
        int directiveCount = this.directives.size();
        if (directiveCount < 2) {
            return;
        }
        Directive prevDirective = null;
        int fetchDirectiveCount = 0;
        boolean isfetchSourceListIdentical = true;
        for (Map.Entry<Class<?>, Directive<DirectiveValue>> entry : this.directives.entrySet()) {
            Directive<? extends DirectiveValue> directive = entry.getValue();
            if (!(directive instanceof FetchDirective)) continue;
            ++fetchDirectiveCount;
            if (prevDirective != null && !prevDirective.sourceListEquals(directive)) {
                isfetchSourceListIdentical = false;
                break;
            }
            prevDirective = (SourceListDirective)directive;
        }
        if (prevDirective != null && fetchDirectiveCount == Directive.FETCH_DIRECIVE_COUNT && isfetchSourceListIdentical) {
            Set combinedSources = prevDirective.values().collect(Collectors.toCollection(LinkedHashSet::new));
            defaultSrcDirective = new DefaultSrcDirective(combinedSources);
            Directive.getFetchDirectives().forEach(x -> this.directives.remove(x));
            this.directives.put(DefaultSrcDirective.class, defaultSrcDirective);
        }
        if (directiveCount == 2 && this.directives.containsKey(ScriptSrcDirective.class) && this.directives.containsKey(StyleSrcDirective.class) && (scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class)).sourceListEquals(styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class)) && scriptSrcDirective.containsKeywordsAndNoncesOnly()) {
            defaultSrcDirective = new DefaultSrcDirective(scriptSrcDirective.values().collect(Collectors.toCollection(LinkedHashSet::new)));
            this.directives.remove(ScriptSrcDirective.class);
            this.directives.remove(StyleSrcDirective.class);
            this.directives.put(DefaultSrcDirective.class, defaultSrcDirective);
        }
    }

    public void unionDirective(@Nonnull Directive<? extends DirectiveValue> directive) {
        this.resolveSelf();
        if (directive instanceof SourceListDirective) {
            directive = ((SourceListDirective)directive).resolveSelf(this.origin);
        }
        if (!(directive instanceof DefaultSrcDirective)) {
            this.expandDefaultSrc();
        }
        Set<Directive> expandedDirectives = Policy.expandDirective(directive);
        expandedDirectives.forEach(x -> this.unionDirectivePrivate(x));
        this.optimise();
    }

    public void intersectDirective(@Nonnull Directive<? extends DirectiveValue> directive) {
        this.resolveSelf();
        if (directive instanceof SourceListDirective) {
            directive = ((SourceListDirective)directive).resolveSelf(this.origin);
        }
        if (!(directive instanceof DefaultSrcDirective)) {
            this.expandDefaultSrc();
        }
        Set<Directive> expandedDirectives = Policy.expandDirective(directive);
        expandedDirectives.forEach(x -> this.intersectDirectivePrivate(x));
        this.optimise();
    }

    private static Set<Directive> expandDirective(@Nonnull Directive<? extends DirectiveValue> directive) {
        if (!(directive instanceof FetchDirective)) {
            return Collections.singleton(directive);
        }
        LinkedHashSet<Directive> directives = new LinkedHashSet<Directive>();
        directives.add(directive);
        Stream<? extends DirectiveValue> stream = directive.values();
        Set sources = stream.collect(Collectors.toCollection(LinkedHashSet::new));
        if (directive instanceof ChildSrcDirective) {
            directives.add(new FrameSrcDirective(sources));
            directives.add(new WorkerSrcDirective(sources));
        } else if (directive instanceof ScriptSrcDirective) {
            directives.add(new ScriptSrcElemDirective(sources));
            directives.add(new ScriptSrcAttrDirective(sources));
            directives.add(new WorkerSrcDirective(sources));
        } else if (directive instanceof StyleSrcDirective) {
            directives.add(new StyleSrcElemDirective(sources));
            directives.add(new StyleSrcAttrDirective(sources));
        }
        return directives;
    }

    private <V extends DirectiveValue, T extends Directive<V>> void unionDirectivePrivate(@Nonnull T directive) {
        Directive<? extends DirectiveValue> oldDirective = this.directives.get(directive.getClass());
        if (oldDirective != null) {
            oldDirective.union(directive);
        }
    }

    private <V extends DirectiveValue, T extends Directive<V>> void intersectDirectivePrivate(@Nonnull T directive) {
        Directive<? extends DirectiveValue> oldDirective = this.directives.get(directive.getClass());
        if (oldDirective != null) {
            oldDirective.intersect(directive);
        } else {
            this.directives.put(directive.getClass(), directive);
        }
    }

    public <V extends DirectiveValue, T extends Directive<V>> void addDirective(@Nonnull T d) {
        Directive<? extends DirectiveValue> directive = this.directives.get(d.getClass());
        if (directive == null) {
            this.directives.put(d.getClass(), d);
            this.expandDefaultSrc();
            this.resolveSelf();
            this.optimise();
        }
    }

    public void addDirectives(@Nonnull Iterable<Directive<? extends DirectiveValue>> directives) {
        for (Directive<? extends DirectiveValue> d : directives) {
            this.directives.put(d.getClass(), d);
        }
        this.expandDefaultSrc();
        this.resolveSelf();
        this.optimise();
    }

    @Nonnull
    public Collection<Directive<? extends DirectiveValue>> getDirectives() {
        return this.directives.values();
    }

    @Nullable
    public <V extends DirectiveValue, T extends Directive<V>> T getDirectiveByType(@Nonnull Class<T> type) {
        Directive<? extends DirectiveValue> d = this.directives.get(type);
        if (d == null) {
            return null;
        }
        return (T)d;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof Policy)) {
            return false;
        }
        return this.directives.size() == ((Policy)other).directives.size() && this.directives.equals(((Policy)other).directives);
    }

    public int hashCode() {
        return this.directives.values().stream().map(Object::hashCode).reduce(434398688, (a, b) -> a ^ b);
    }

    @Override
    @Nonnull
    public String show() {
        StringBuilder sb = new StringBuilder();
        if (this.directives.isEmpty()) {
            return "";
        }
        boolean first = true;
        for (Directive<? extends DirectiveValue> d : this.directives.values()) {
            if (!first) {
                sb.append("; ");
            }
            first = false;
            sb.append(d.show());
        }
        return sb.toString();
    }

    private boolean defaultsAllowAttributeWithHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        if (!this.defaultsHaveUnsafeHashes()) {
            return false;
        }
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return true;
        }
        return defaultSrcDirective.matchesHash(algorithm, hashValue);
    }

    private boolean defaultsAllowHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        if (this.defaultsHaveUnsafeInline() && !this.defaultsHaveNonceSource() && !this.defaultsHaveHashSource() && !this.defaultsHaveStrictDynamic()) {
            return true;
        }
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return true;
        }
        return defaultSrcDirective.matchesHash(algorithm, hashValue);
    }

    private boolean defaultsAllowNonce(@Nonnull String nonce) {
        if (this.defaultsHaveUnsafeInline() && !this.defaultsHaveHashSource() && !this.defaultsHaveNonceSource() && !this.defaultsHaveStrictDynamic()) {
            return true;
        }
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return true;
        }
        return defaultSrcDirective.matchesNonce(nonce);
    }

    private boolean defaultsAllowSource(@Nonnull URI source) {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return true;
        }
        return defaultSrcDirective.matchesSource(this.origin, source);
    }

    private boolean defaultsAllowSource(@Nonnull GUID source) {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return true;
        }
        return defaultSrcDirective.matchesSource(this.origin, source);
    }

    private boolean defaultsHaveUnsafeInline() {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return false;
        }
        return defaultSrcDirective.values().anyMatch(x -> x == KeywordSource.UnsafeInline);
    }

    private boolean defaultsHaveUnsafeHashes() {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return false;
        }
        return defaultSrcDirective.values().anyMatch(x -> x == KeywordSource.UnsafeHashes);
    }

    private boolean defaultsHaveNonceSource() {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return false;
        }
        return defaultSrcDirective.values().anyMatch(x -> x instanceof NonceSource);
    }

    private boolean defaultsHaveHashSource() {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return false;
        }
        return defaultSrcDirective.values().anyMatch(x -> x instanceof HashSource);
    }

    private boolean defaultsHaveStrictDynamic() {
        DefaultSrcDirective defaultSrcDirective = this.getDirectiveByType(DefaultSrcDirective.class);
        if (defaultSrcDirective == null) {
            return false;
        }
        return defaultSrcDirective.values().anyMatch(x -> x == KeywordSource.StrictDynamic);
    }

    public boolean hasStrictDynamic() {
        ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
        if (scriptSrcDirective == null) {
            return this.defaultsHaveStrictDynamic();
        }
        return scriptSrcDirective.values().anyMatch(x -> x == KeywordSource.StrictDynamic);
    }

    public boolean allowsImgFromSource(@Nonnull URI source) {
        ImgSrcDirective imgSrcDirective = this.getDirectiveByType(ImgSrcDirective.class);
        if (imgSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return imgSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsImgFromSource(@Nonnull GUID source) {
        ImgSrcDirective imgSrcDirective = this.getDirectiveByType(ImgSrcDirective.class);
        if (imgSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return imgSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsPrefetchFromSource(@Nonnull URI source) {
        PrefetchSrcDirective prefetchSrcDirective = this.getDirectiveByType(PrefetchSrcDirective.class);
        if (prefetchSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return prefetchSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsPrefetchFromSource(@Nonnull GUID source) {
        PrefetchSrcDirective PrefetchSrcDirective2 = this.getDirectiveByType(PrefetchSrcDirective.class);
        if (PrefetchSrcDirective2 == null) {
            return this.defaultsAllowSource(source);
        }
        return PrefetchSrcDirective2.matchesSource(this.origin, source);
    }

    public boolean allowsScriptFromSource(@Nonnull URI source) {
        ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
        if (scriptSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return scriptSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsScriptFromSource(@Nonnull GUID source) {
        ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
        if (scriptSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return scriptSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsStyleFromSource(@Nonnull URI source) {
        StyleSrcDirective styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
        if (styleSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return styleSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsStyleFromSource(@Nonnull GUID source) {
        StyleSrcDirective styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
        if (styleSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return styleSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsConnectTo(@Nonnull URI source) {
        ConnectSrcDirective connectSrcDirective = this.getDirectiveByType(ConnectSrcDirective.class);
        if (connectSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return connectSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsConnectTo(@Nonnull GUID source) {
        ConnectSrcDirective connectSrcDirective = this.getDirectiveByType(ConnectSrcDirective.class);
        if (connectSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return connectSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsStyleWithHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        if (this.allowsUnsafeInlineStyle()) {
            return true;
        }
        StyleSrcElemDirective styleSrcElemDirective = this.getDirectiveByType(StyleSrcElemDirective.class);
        if (styleSrcElemDirective != null) {
            return styleSrcElemDirective.matchesHash(algorithm, hashValue);
        }
        StyleSrcDirective styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
        if (styleSrcDirective != null) {
            return styleSrcDirective.matchesHash(algorithm, hashValue);
        }
        return this.defaultsAllowHash(algorithm, hashValue);
    }

    public boolean allowsScriptWithHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        if (this.allowsUnsafeInlineScript()) {
            return true;
        }
        ScriptSrcElemDirective scriptSrcElemDirective = this.getDirectiveByType(ScriptSrcElemDirective.class);
        if (scriptSrcElemDirective != null) {
            return scriptSrcElemDirective.matchesHash(algorithm, hashValue);
        }
        ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
        if (scriptSrcDirective != null) {
            return scriptSrcDirective.matchesHash(algorithm, hashValue);
        }
        return this.defaultsAllowHash(algorithm, hashValue);
    }

    public boolean allowsScriptAttributeWithHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        if (!this.haveUnsafeScriptHashes()) {
            return false;
        }
        ScriptSrcAttrDirective scriptSrcAttrDirective = this.getDirectiveByType(ScriptSrcAttrDirective.class);
        if (scriptSrcAttrDirective == null) {
            ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
            if (scriptSrcDirective == null) {
                return this.defaultsAllowAttributeWithHash(algorithm, hashValue);
            }
            return scriptSrcDirective.matchesHash(algorithm, hashValue);
        }
        return scriptSrcAttrDirective.matchesHash(algorithm, hashValue);
    }

    public boolean allowsStyleAttributeWithHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        if (!this.haveUnsafeStyleHashes()) {
            return false;
        }
        StyleSrcAttrDirective styleSrcAttrDirective = this.getDirectiveByType(StyleSrcAttrDirective.class);
        if (styleSrcAttrDirective == null) {
            StyleSrcDirective styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
            if (styleSrcDirective == null) {
                return this.defaultsAllowAttributeWithHash(algorithm, hashValue);
            }
            return styleSrcDirective.matchesHash(algorithm, hashValue);
        }
        return styleSrcAttrDirective.matchesHash(algorithm, hashValue);
    }

    public boolean allowsUnsafeInlineScript() {
        return this.containsSourceExpression(ScriptSrcDirective.class, x -> x == KeywordSource.UnsafeInline) && !this.containsSourceExpression(ScriptSrcDirective.class, x -> x instanceof NonceSource) && !this.containsSourceExpression(ScriptSrcDirective.class, x -> x instanceof HashSource) && !this.containsSourceExpression(ScriptSrcDirective.class, x -> x == KeywordSource.StrictDynamic);
    }

    public boolean haveUnsafeScriptHashes() {
        return this.containsSourceExpression(ScriptSrcAttrDirective.class, x -> x == KeywordSource.UnsafeHashes) || this.containsSourceExpression(ScriptSrcDirective.class, x -> x == KeywordSource.UnsafeHashes) || this.defaultsHaveUnsafeHashes();
    }

    public boolean haveUnsafeStyleHashes() {
        return this.containsSourceExpression(StyleSrcAttrDirective.class, x -> x == KeywordSource.UnsafeHashes) || this.containsSourceExpression(StyleSrcDirective.class, x -> x == KeywordSource.UnsafeHashes) || this.defaultsHaveUnsafeHashes();
    }

    public <T extends SourceListDirective> boolean containsSourceExpression(Class<T> type, @Nonnull Predicate<SourceExpression> predicate) {
        SourceListDirective d = (SourceListDirective)this.getDirectiveByType(type);
        if (d == null) {
            return type != DefaultSrcDirective.class && this.containsSourceExpression(DefaultSrcDirective.class, predicate);
        }
        return d.values().anyMatch(predicate);
    }

    @Nonnull
    public <T extends SourceListDirective> Stream<SourceExpression> getEffectiveSourceExpressions(Class<T> type) {
        SourceListDirective d = (SourceListDirective)this.getDirectiveByType(type);
        if (d == null && type != DefaultSrcDirective.class) {
            d = this.getDirectiveByType(DefaultSrcDirective.class);
        }
        return d != null ? d.values() : Stream.empty();
    }

    public boolean allowsUnsafeInlineStyle() {
        return this.containsSourceExpression(StyleSrcDirective.class, x -> x == KeywordSource.UnsafeInline) && !this.containsSourceExpression(StyleSrcDirective.class, x -> x instanceof NonceSource) && !this.containsSourceExpression(StyleSrcDirective.class, x -> x instanceof HashSource);
    }

    public boolean allowsPlugin(@Nonnull MediaType mediaType) {
        PluginTypesDirective pluginTypesDirective = this.getDirectiveByType(PluginTypesDirective.class);
        if (pluginTypesDirective == null) {
            return false;
        }
        return pluginTypesDirective.matchesMediaType(mediaType);
    }

    public boolean allowsScriptWithNonce(@Nonnull String nonce) {
        if (this.allowsUnsafeInlineScript()) {
            return true;
        }
        ScriptSrcElemDirective scriptSrcElemDirective = this.getDirectiveByType(ScriptSrcElemDirective.class);
        if (scriptSrcElemDirective != null) {
            return scriptSrcElemDirective.matchesNonce(nonce);
        }
        ScriptSrcDirective scriptSrcDirective = this.getDirectiveByType(ScriptSrcDirective.class);
        if (scriptSrcDirective != null) {
            return scriptSrcDirective.matchesNonce(nonce);
        }
        return this.defaultsAllowNonce(nonce);
    }

    public boolean allowsScriptWithNonce(@Nonnull Base64Value nonce) {
        return this.allowsScriptWithNonce(nonce.value);
    }

    public boolean allowsStyleWithNonce(@Nonnull String nonce) {
        if (this.allowsUnsafeInlineStyle()) {
            return true;
        }
        StyleSrcElemDirective styleSrcElemDirective = this.getDirectiveByType(StyleSrcElemDirective.class);
        if (styleSrcElemDirective != null) {
            return styleSrcElemDirective.matchesNonce(nonce);
        }
        StyleSrcDirective styleSrcDirective = this.getDirectiveByType(StyleSrcDirective.class);
        if (styleSrcDirective != null) {
            return styleSrcDirective.matchesNonce(nonce);
        }
        return this.defaultsAllowNonce(nonce);
    }

    public boolean allowsStyleWithNonce(@Nonnull Base64Value nonce) {
        return this.allowsStyleWithNonce(nonce.value);
    }

    public boolean allowsChildFromSource(@Nonnull URI source) {
        ChildSrcDirective childSrcDirective = this.getDirectiveByType(ChildSrcDirective.class);
        if (childSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return childSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsChildFromSource(@Nonnull GUID source) {
        ChildSrcDirective childSrcDirective = this.getDirectiveByType(ChildSrcDirective.class);
        if (childSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return childSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsWorkerFromSource(@Nonnull URI source) {
        WorkerSrcDirective workerSrcDirective = this.getDirectiveByType(WorkerSrcDirective.class);
        if (workerSrcDirective == null) {
            return this.allowsScriptFromSource(source);
        }
        return workerSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsWorkerFromSource(@Nonnull GUID source) {
        WorkerSrcDirective workerSrcDirective = this.getDirectiveByType(WorkerSrcDirective.class);
        if (workerSrcDirective == null) {
            return this.allowsScriptFromSource(source);
        }
        return workerSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsFrameFromSource(@Nonnull URI source) {
        FrameSrcDirective frameSrcDirective = this.getDirectiveByType(FrameSrcDirective.class);
        if (frameSrcDirective == null) {
            return this.allowsChildFromSource(source);
        }
        return frameSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsFrameFromSource(@Nonnull GUID source) {
        FrameSrcDirective frameSrcDirective = this.getDirectiveByType(FrameSrcDirective.class);
        if (frameSrcDirective == null) {
            return this.allowsChildFromSource(source);
        }
        return frameSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsFrameAncestor(@Nonnull URI source) {
        FrameAncestorsDirective frameAncestorsDirective = this.getDirectiveByType(FrameAncestorsDirective.class);
        if (frameAncestorsDirective == null) {
            return true;
        }
        return frameAncestorsDirective.matchesSource(this.origin, source);
    }

    public boolean allowsFrameAncestor(@Nonnull GUID source) {
        FrameAncestorsDirective frameAncestorsDirective = this.getDirectiveByType(FrameAncestorsDirective.class);
        if (frameAncestorsDirective == null) {
            return true;
        }
        return frameAncestorsDirective.matchesSource(this.origin, source);
    }

    public boolean allowsFontFromSource(@Nonnull URI source) {
        FontSrcDirective fontSrcDirective = this.getDirectiveByType(FontSrcDirective.class);
        if (fontSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return fontSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsFontFromSource(@Nonnull GUID source) {
        FontSrcDirective fontSrcDirective = this.getDirectiveByType(FontSrcDirective.class);
        if (fontSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return fontSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsObjectFromSource(@Nonnull URI source) {
        ObjectSrcDirective objectSrcDirective = this.getDirectiveByType(ObjectSrcDirective.class);
        if (objectSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return objectSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsObjectFromSource(@Nonnull GUID source) {
        ObjectSrcDirective objectSrcDirective = this.getDirectiveByType(ObjectSrcDirective.class);
        if (objectSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return objectSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsMediaFromSource(@Nonnull URI source) {
        MediaSrcDirective mediaSrcDirective = this.getDirectiveByType(MediaSrcDirective.class);
        if (mediaSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return mediaSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsMediaFromSource(@Nonnull GUID source) {
        MediaSrcDirective mediaSrcDirective = this.getDirectiveByType(MediaSrcDirective.class);
        if (mediaSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return mediaSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsManifestFromSource(@Nonnull URI source) {
        ManifestSrcDirective manifestSrcDirective = this.getDirectiveByType(ManifestSrcDirective.class);
        if (manifestSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return manifestSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsManifestFromSource(@Nonnull GUID source) {
        ManifestSrcDirective manifestSrcDirective = this.getDirectiveByType(ManifestSrcDirective.class);
        if (manifestSrcDirective == null) {
            return this.defaultsAllowSource(source);
        }
        return manifestSrcDirective.matchesSource(this.origin, source);
    }

    public boolean allowsNavigation(@Nonnull URI destination) {
        NavigateToDirective navigateToDirective = this.getDirectiveByType(NavigateToDirective.class);
        if (navigateToDirective == null) {
            return true;
        }
        return navigateToDirective.matchesSource(this.origin, destination);
    }

    public boolean allowsNavigation(@Nonnull GUID destination) {
        NavigateToDirective navigateToDirective = this.getDirectiveByType(NavigateToDirective.class);
        if (navigateToDirective == null) {
            return true;
        }
        return navigateToDirective.matchesSource(this.origin, destination);
    }

    public boolean allowsFormAction(@Nonnull URI destination) {
        FormActionDirective formActionDirective = this.getDirectiveByType(FormActionDirective.class);
        if (formActionDirective == null) {
            return this.allowsNavigation(destination);
        }
        return formActionDirective.matchesSource(this.origin, destination);
    }

    public boolean allowsFormAction(@Nonnull GUID destination) {
        FormActionDirective formActionDirective = this.getDirectiveByType(FormActionDirective.class);
        if (formActionDirective == null) {
            return this.allowsNavigation(destination);
        }
        return formActionDirective.matchesSource(this.origin, destination);
    }

    public boolean hasSomeEffect() {
        for (Map.Entry<Class<?>, Directive<DirectiveValue>> entry : this.directives.entrySet()) {
            Directive<? extends DirectiveValue> directive = entry.getValue();
            if (directive instanceof ReportToDirective || directive instanceof ReportUriDirective) continue;
            return true;
        }
        return false;
    }

    private void insert(@Nonnull Directive x) {
        if (this.getDirectiveByType(x.getClass()) == null) {
            this.directives.put(x.getClass(), x);
        }
    }
}

