/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.fife.print.RPrintUtilities;
import org.fife.ui.rtextarea.ChangableHighlightPainter;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextarea.Macro;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaDocument;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.fife.ui.rtextarea.SearchEngine;

public class RTextArea
extends RTextAreaBase
implements Printable,
Serializable {
    public static final int INSERT_MODE = 0;
    public static final int OVERWRITE_MODE = 1;
    public static final String MARK_ALL_COLOR_PROPERTY = "RTA.markAllColor";
    private static final int MIN_ACTION_CONSTANT = 0;
    public static final int COPY_ACTION = 0;
    public static final int CUT_ACTION = 1;
    public static final int DELETE_ACTION = 2;
    public static final int LINE_DOWN_ACTION = 3;
    public static final int LINE_UP_ACTION = 4;
    public static final int PASTE_ACTION = 5;
    public static final int REDO_ACTION = 6;
    public static final int SELECT_ALL_ACTION = 7;
    public static final int UNDO_ACTION = 8;
    private static final int MAX_ACTION_CONSTANT = 8;
    private static final Color DEFAULT_MARK_ALL_COLOR = Color.ORANGE;
    private int textMode;
    private static boolean recordingMacro;
    private static Macro currentMacro;
    private static JPopupMenu rightClickMenu;
    private static RecordableTextAction cutAction;
    private static RecordableTextAction copyAction;
    private static RecordableTextAction pasteAction;
    private static RecordableTextAction deleteAction;
    private static RecordableTextAction lineDownAction;
    private static RecordableTextAction lineUpAction;
    private static RecordableTextAction undoAction;
    private static RecordableTextAction redoAction;
    private static RecordableTextAction selectAllAction;
    private static IconGroup iconGroup;
    private RUndoManager undoManager;
    private ArrayList markAllHighlights;
    private String markedWord;
    private ChangableHighlightPainter markAllHighlightPainter;
    private boolean inUndoRedo;
    public static final int INSERT_CARET = 0;
    public static final int OVERWRITE_CARET = 1;
    private int[] carets;
    private static String cantUndoText;
    private static String cantRedoText;
    private static final String RESOURCE_BUNDLE = "org.fife.ui.rtextarea.RTextArea";
    private static boolean first;
    private StringBuffer repTabsSB;

    public RTextArea() {
        this(null, false, 0);
    }

    public RTextArea(Font font, boolean bl, int n) {
        super(font, bl);
        RTextArea.initActions(this);
        this.getDocument().putProperty("__EndOfLine__", System.getProperty("line.separator"));
        Color color = RTextArea.getDefaultMarkAllHighlightColor();
        this.markAllHighlightPainter = new ChangableHighlightPainter(color);
        this.setMarkAllHighlightColor(color);
        this.carets = new int[2];
        this.carets[0] = 0;
        this.carets[1] = 2;
        this.setDragEnabled(true);
        this.setTextMode(n);
        this.undoManager = new RUndoManager(this);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.fixCtrlH();
    }

    static synchronized void addToCurrentMacro(String string, String string2) {
        currentMacro.addMacroRecord(new Macro.MacroRecord(string, string2));
    }

    public static synchronized void beginRecordingMacro() {
        if (RTextArea.isRecordingMacro()) {
            return;
        }
        if (currentMacro != null) {
            currentMacro = null;
        }
        currentMacro = new Macro();
        recordingMacro = true;
    }

    public void clearMarkAllHighlights() {
        Highlighter highlighter = this.getHighlighter();
        if (highlighter != null && this.markAllHighlights != null) {
            int n = this.markAllHighlights.size();
            for (int i = 0; i < n; ++i) {
                highlighter.removeHighlight(this.markAllHighlights.get(i));
            }
            this.markAllHighlights.clear();
        }
        this.markedWord = null;
        this.repaint();
    }

    protected Document createDefaultModel() {
        return new RTextAreaDocument();
    }

    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RTextAreaMutableCaretEvent(this);
    }

    private static void createRightClickMenu() {
        rightClickMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(undoAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(redoAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        rightClickMenu.addSeparator();
        jMenuItem = new JMenuItem(cutAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(copyAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(pasteAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(deleteAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        rightClickMenu.addSeparator();
        jMenuItem = new JMenuItem(selectAllAction);
        jMenuItem.setAccelerator(null);
        jMenuItem.setToolTipText(null);
        rightClickMenu.add(jMenuItem);
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        rightClickMenu.applyComponentOrientation(componentOrientation);
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new RTextAreaUI(this);
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        this.getDocument().removeUndoableEditListener(this.undoManager);
        this.undoManager = new RUndoManager(this);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.undoManager.updateActions();
    }

    public static synchronized void endRecordingMacro() {
        if (!RTextArea.isRecordingMacro()) {
            return;
        }
        recordingMacro = false;
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        this.possiblyUpdateCurrentLineHighlightLocation();
        if (caretEvent != null && caretEvent.getDot() != caretEvent.getMark()) {
            cutAction.setEnabled(true);
            copyAction.setEnabled(true);
        } else if (cutAction.isEnabled()) {
            cutAction.setEnabled(false);
            copyAction.setEnabled(false);
        }
        super.fireCaretUpdate(caretEvent);
    }

    private void fixCtrlH() {
        InputMap inputMap = this.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke("typed \b");
        for (InputMap inputMap2 = inputMap; inputMap2 != null; inputMap2 = inputMap2.getParent()) {
            inputMap2.remove(keyStroke);
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("BACK_SPACE");
        inputMap.put(keyStroke2, "delete-previous");
    }

    public static RecordableTextAction getAction(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        switch (n) {
            case 0: {
                return copyAction;
            }
            case 1: {
                return cutAction;
            }
            case 2: {
                return deleteAction;
            }
            case 3: {
                return lineDownAction;
            }
            case 4: {
                return lineUpAction;
            }
            case 5: {
                return pasteAction;
            }
            case 6: {
                return redoAction;
            }
            case 7: {
                return selectAllAction;
            }
            case 8: {
                return undoAction;
            }
        }
        return null;
    }

    public static synchronized Macro getCurrentMacro() {
        return currentMacro;
    }

    public static final Color getDefaultMarkAllHighlightColor() {
        return DEFAULT_MARK_ALL_COLOR;
    }

    public static IconGroup getIconGroup() {
        return iconGroup;
    }

    public Color getMarkAllHighlightColor() {
        return (Color)this.markAllHighlightPainter.getPaint();
    }

    public int getMaxAscent() {
        return this.getFontMetrics(this.getFont()).getAscent();
    }

    public final int getTextMode() {
        return this.textMode;
    }

    protected void handleReplaceSelection(String string) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                Caret caret = this.getCaret();
                int n = caret.getDot();
                int n2 = caret.getMark();
                int n3 = Math.min(n, n2);
                int n4 = Math.max(n, n2);
                ((RTextAreaDocument)document).replace(n3, n4 - n3, string, null);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    private static final synchronized void initActions(RTextArea rTextArea) {
        if (!first) {
            first = true;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
            cantUndoText = resourceBundle.getString("CantUndo");
            cantRedoText = resourceBundle.getString("CantRedo");
            int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            String string = resourceBundle.getString("CutActionName");
            char c = resourceBundle.getString("CutActionMnemonic").charAt(0);
            cutAction = new RTextAreaEditorKit.CutAction(string, null, string, new Integer(c), KeyStroke.getKeyStroke(88, n));
            string = resourceBundle.getString("CopyActionName");
            c = resourceBundle.getString("CopyActionMnemonic").charAt(0);
            copyAction = new RTextAreaEditorKit.CopyAction(string, null, string, new Integer(c), KeyStroke.getKeyStroke(67, n));
            string = resourceBundle.getString("PasteActionName");
            c = resourceBundle.getString("PasteActionMnemonic").charAt(0);
            pasteAction = new RTextAreaEditorKit.PasteAction(string, null, string, new Integer(c), KeyStroke.getKeyStroke(86, n));
            string = resourceBundle.getString("DeleteActionName");
            c = resourceBundle.getString("DeleteActionMnemonic").charAt(0);
            deleteAction = new RTextAreaEditorKit.DeleteNextCharAction(string, null, string, new Integer(c), KeyStroke.getKeyStroke(127, 0));
            undoAction = new RTextAreaEditorKit.UndoAction(cantUndoText, null, "Undo", new Integer(90), KeyStroke.getKeyStroke(90, n));
            redoAction = new RTextAreaEditorKit.RedoAction(cantRedoText, null, "Redo", new Integer(89), KeyStroke.getKeyStroke(89, n));
            string = resourceBundle.getString("SAActionName");
            c = resourceBundle.getString("SAActionMnemonic").charAt(0);
            selectAllAction = new RTextAreaEditorKit.SelectAllAction(string, null, string, new Integer(c), KeyStroke.getKeyStroke(65, n));
            resourceBundle = null;
        }
    }

    boolean inUndoRedo() {
        return this.inUndoRedo;
    }

    public static synchronized boolean isRecordingMacro() {
        return recordingMacro;
    }

    public static synchronized void loadMacro(Macro macro) {
        currentMacro = macro;
    }

    public int markAll(String string, boolean bl, boolean bl2, boolean bl3) {
        Highlighter highlighter = this.getHighlighter();
        int n = 0;
        if (string != null && !string.equals(this.markedWord) && highlighter != null) {
            if (this.markAllHighlights != null) {
                this.clearMarkAllHighlights();
            } else {
                this.markAllHighlights = new ArrayList(10);
            }
            int n2 = this.getCaretPosition();
            this.markedWord = string;
            this.setCaretPosition(0);
            boolean bl4 = SearchEngine.find(this, string, true, bl, bl2, bl3);
            while (bl4) {
                int n3 = this.getSelectionStart();
                int n4 = this.getSelectionEnd();
                try {
                    this.markAllHighlights.add(highlighter.addHighlight(n3, n4, this.markAllHighlightPainter));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                ++n;
                bl4 = SearchEngine.find(this, string, true, bl, bl2, bl3);
            }
            this.setCaretPosition(n2);
            this.repaint();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void playbackLastMacro() {
        if (currentMacro != null) {
            Action[] actionArray = this.getActions();
            int n = actionArray.length;
            List list = currentMacro.getMacroRecords();
            int n2 = list.size();
            if (n2 > 0) {
                this.undoManager.beginInternalAtomicEdit();
                try {
                    block3: for (int i = 0; i < n2; ++i) {
                        Macro.MacroRecord macroRecord = (Macro.MacroRecord)list.get(i);
                        for (int j = 0; j < n; ++j) {
                            if (!(actionArray[j] instanceof RecordableTextAction) || !macroRecord.id.equals(((RecordableTextAction)actionArray[j]).getMacroID())) continue;
                            actionArray[j].actionPerformed(new ActionEvent(this, 1001, macroRecord.actionCommand));
                            continue block3;
                        }
                    }
                }
                finally {
                    this.undoManager.endInternalAtomicEdit();
                }
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return RPrintUtilities.printDocumentWordWrap(graphics, this, this.getFont(), n, pageFormat, this.getTabSize());
    }

    public void read(Reader reader, Object object) throws IOException {
        RTextAreaEditorKit rTextAreaEditorKit = (RTextAreaEditorKit)this.getUI().getEditorKit(this);
        this.setText(null);
        Document document = this.getDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            rTextAreaEditorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void redoLastAction() {
        try {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            cannotRedoException.printStackTrace();
        }
    }

    public void replaceRange(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("end before start");
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                this.undoManager.beginInternalAtomicEdit();
                ((RTextAreaDocument)document).replace(n, n2 - n, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
            finally {
                this.undoManager.endInternalAtomicEdit();
            }
        }
    }

    public void replaceSelection(String string) {
        if (string == null) {
            this.handleReplaceSelection(string);
            return;
        }
        if (this.getTabsEmulated() && string.indexOf(9) > -1) {
            string = this.replaceTabsWithSpaces(string);
        }
        if (this.textMode == 1) {
            Caret caret = this.getCaret();
            int n = caret.getDot();
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            int n3 = element.getElementCount() - 1;
            try {
                if (string.equals("\n")) {
                    if (n2 == n3) {
                        this.setCaretPosition(this.getLineEndOffset(n2));
                        this.handleReplaceSelection(string);
                    } else {
                        this.setCaretPosition(this.getLineStartOffset(n2 + 1));
                    }
                    return;
                }
                int n4 = this.getLineEndOffset(n2);
                if (n == caret.getMark() && n != n4) {
                    n = n2 == n3 ? Math.min(n + string.length(), n4) : Math.min(n + string.length(), n4 - 1);
                    caret.moveDot(n);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                badLocationException.printStackTrace();
            }
        }
        this.handleReplaceSelection(string);
    }

    private final String replaceTabsWithSpaces(String string) {
        String string2 = "";
        int n = this.getTabSize();
        for (int i = 0; i < n; ++i) {
            string2 = string2 + ' ';
        }
        if (string.length() == 1) {
            return string2;
        }
        if (this.repTabsSB == null) {
            this.repTabsSB = new StringBuffer();
        }
        this.repTabsSB.setLength(0);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(9, n2)) > -1) {
            if (n3 > n2) {
                this.repTabsSB.append(cArray, n2, n3 - n2);
            }
            this.repTabsSB.append(string2);
            n2 = n3 + 1;
        }
        if (n2 < cArray.length) {
            this.repTabsSB.append(cArray, n2, cArray.length - n2);
        }
        return this.repTabsSB.toString();
    }

    public static void setActionProperties(int n, String string, char c, KeyStroke keyStroke) {
        RTextArea.setActionProperties(n, string, new Integer(c), keyStroke);
    }

    public static void setActionProperties(int n, String string, Integer n2, KeyStroke keyStroke) {
        RecordableTextAction recordableTextAction = null;
        switch (n) {
            case 1: {
                recordableTextAction = cutAction;
                break;
            }
            case 0: {
                recordableTextAction = copyAction;
                break;
            }
            case 5: {
                recordableTextAction = pasteAction;
                break;
            }
            case 2: {
                recordableTextAction = deleteAction;
                break;
            }
            case 7: {
                recordableTextAction = selectAllAction;
                break;
            }
            default: {
                return;
            }
        }
        recordableTextAction.putValue("Name", string);
        recordableTextAction.putValue("ShortDescription", string);
        recordableTextAction.putValue("AcceleratorKey", keyStroke);
        recordableTextAction.putValue("MnemonicKey", n2);
    }

    public void setCaret(Caret caret) {
        if (!(caret instanceof ConfigurableCaret)) {
            throw new IllegalArgumentException("RTextArea needs ConfigurableCaret");
        }
        super.setCaret(caret);
    }

    public void setCaretStyle(int n, int n2) {
        this.carets[n] = n2 = n2 >= 0 && n2 <= 3 ? n2 : 0;
        if (n == this.getTextMode()) {
            ((ConfigurableCaret)this.getCaret()).setStyle(n2);
        }
    }

    public void setDocument(Document document) {
        if (!(document instanceof RTextAreaDocument)) {
            throw new IllegalArgumentException("RTextArea requires instances of RTextAreaDocument for its document!");
        }
        super.setDocument(document);
    }

    public static synchronized void setIconGroup(IconGroup iconGroup) {
        Icon icon = iconGroup.getIcon("cut");
        cutAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("copy");
        copyAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("paste");
        pasteAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("delete");
        deleteAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("undo");
        undoAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("redo");
        redoAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("selectall");
        selectAllAction.putValue("SmallIcon", icon);
        RTextArea.iconGroup = iconGroup;
    }

    public void setMarkAllHighlightColor(Color color) {
        Color color2 = (Color)this.markAllHighlightPainter.getPaint();
        if (color2 != null && !color2.equals(color)) {
            this.markAllHighlightPainter.setPaint(color);
            if (this.markedWord != null) {
                this.repaint();
            }
            this.firePropertyChange(MARK_ALL_COLOR_PROPERTY, color2, color);
        }
    }

    public void setRoundedSelectionEdges(boolean bl) {
        if (this.getRoundedSelectionEdges() != bl) {
            this.markAllHighlightPainter.setRoundedEdges(bl);
            super.setRoundedSelectionEdges(bl);
        }
    }

    public void setTextMode(int n) {
        if (n != 0 && n != 1) {
            n = 0;
        }
        if (this.textMode != n) {
            ConfigurableCaret configurableCaret = (ConfigurableCaret)this.getCaret();
            configurableCaret.setStyle(this.carets[n]);
            this.textMode = n;
        }
    }

    public final void setUI(TextUI textUI) {
        if (rightClickMenu != null) {
            SwingUtilities.updateComponentTreeUI(rightClickMenu);
        }
    }

    public void undoLastAction() {
        try {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            JOptionPane.showMessageDialog(this, "Error doing Undo: " + cannotUndoException + "\nPlease report this at " + "http://sourceforge.net/projects/rtext", "rtext - Error", 0);
        }
    }

    static {
        first = false;
    }

    class RUndoManager
    extends UndoManager {
        public RCompoundEdit compoundEdit;
        private RTextArea textArea;
        private int lastOffset;
        private boolean internalAtomicEdit;

        public RUndoManager(RTextArea rTextArea2) {
            this.textArea = rTextArea2;
        }

        public void beginInternalAtomicEdit() {
            if (this.compoundEdit != null) {
                this.compoundEdit.end();
            }
            this.compoundEdit = new RCompoundEdit();
            this.internalAtomicEdit = true;
        }

        public void endInternalAtomicEdit() {
            this.addEdit(this.compoundEdit);
            this.compoundEdit.end();
            this.compoundEdit = null;
            this.internalAtomicEdit = false;
            this.updateActions();
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (this.compoundEdit == null) {
                this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
                this.updateActions();
                return;
            }
            if (this.internalAtomicEdit) {
                this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                return;
            }
            int n = this.textArea.getCaretPosition() - this.lastOffset;
            if (Math.abs(n) <= 1) {
                this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                this.lastOffset += n;
                return;
            }
            this.compoundEdit.end();
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
        }

        private RCompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
            this.lastOffset = this.textArea.getCaretPosition();
            this.compoundEdit = new RCompoundEdit();
            this.compoundEdit.addEdit(undoableEdit);
            this.addEdit(this.compoundEdit);
            return this.compoundEdit;
        }

        public void undo() throws CannotUndoException {
            RTextArea.this.inUndoRedo = true;
            super.undo();
            this.updateActions();
            RTextArea.this.inUndoRedo = false;
        }

        public void redo() throws CannotRedoException {
            RTextArea.this.inUndoRedo = true;
            super.redo();
            this.updateActions();
            RTextArea.this.inUndoRedo = false;
        }

        public void updateActions() {
            String string;
            if (this.canUndo()) {
                undoAction.setEnabled(true);
                string = this.getUndoPresentationName();
                undoAction.putValue("Name", string);
                undoAction.putValue("ShortDescription", string);
            } else if (undoAction.isEnabled()) {
                undoAction.setEnabled(false);
                string = cantUndoText;
                undoAction.putValue("Name", string);
                undoAction.putValue("ShortDescription", string);
            }
            if (this.canRedo()) {
                redoAction.setEnabled(true);
                string = this.getRedoPresentationName();
                redoAction.putValue("Name", string);
                redoAction.putValue("ShortDescription", string);
            } else if (redoAction.isEnabled()) {
                redoAction.setEnabled(false);
                string = cantRedoText;
                redoAction.putValue("Name", string);
                redoAction.putValue("ShortDescription", string);
            }
        }

        class RCompoundEdit
        extends CompoundEdit {
            RCompoundEdit() {
            }

            public String getUndoPresentationName() {
                return UIManager.getString("AbstractUndoableEdit.undoText");
            }

            public String getRedoPresentationName() {
                return UIManager.getString("AbstractUndoableEdit.redoText");
            }

            public boolean isInProgress() {
                return false;
            }

            public void undo() throws CannotUndoException {
                if (RUndoManager.this.compoundEdit != null) {
                    RUndoManager.this.compoundEdit.end();
                }
                super.undo();
                RUndoManager.this.compoundEdit = null;
            }
        }
    }

    private class RTextAreaMutableCaretEvent
    extends RTextAreaBase.RTAMouseListener {
        RTextAreaMutableCaretEvent(RTextArea rTextArea2) {
            super(RTextArea.this, rTextArea2);
        }

        public void focusGained(FocusEvent focusEvent) {
            Caret caret = RTextArea.this.getCaret();
            boolean bl = caret.getDot() != caret.getMark();
            cutAction.setEnabled(bl);
            copyAction.setEnabled(bl);
            RTextArea.this.undoManager.updateActions();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                Caret caret = RTextArea.this.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                RTextArea.this.fireCaretUpdate(this);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                Caret caret = RTextArea.this.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                RTextArea.this.fireCaretUpdate(this);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (rightClickMenu == null) {
                RTextArea.createRightClickMenu();
            }
            rightClickMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

