/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.SequenceGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLServerSequenceGenerator
extends SequenceGenerator {
    private static final Logger logger = Logger.getLogger(SQLServerSequenceGenerator.class);
    private Connection con;

    public SQLServerSequenceGenerator(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong(String sequenceTable) throws SQLException {
        long nextval;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT currval FROM ").append(SQL.escapeStatement(sequenceTable)).append(";");
        logger.debug((Object)("Sequence Generator select SQL statement is: " + selectSql));
        Statement stmt = null;
        int oldTransactionIsolation = this.con.getTransactionIsolation();
        try {
            this.con.setTransactionIsolation(8);
            stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(selectSql.toString());
            if (!rs.next()) {
                throw new SQLException("The sequence returned nothing!");
            }
            nextval = rs.getLong(1) + 1L;
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("UPDATE ").append(SQL.escapeStatement(sequenceTable));
            updateSql.append(" SET currval=" + nextval);
            logger.debug((Object)("Sequence Generator update SQL statement is: " + updateSql));
            int updateRS = stmt.executeUpdate(updateSql.toString());
            if (updateRS == 0) {
                throw new SQLException("No rows were updated. Serializability should prevent this.");
            }
            rs.close();
        }
        finally {
            this.con.setTransactionIsolation(oldTransactionIsolation);
            if (stmt != null) {
                stmt.close();
            }
        }
        return nextval;
    }

    @Override
    public void close() throws SQLException {
        if (this.con != null) {
            this.con.close();
        }
    }
}

