/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class PrivacyProvider
extends IQProvider<Privacy> {
    @Override
    public Privacy parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        Privacy privacy = new Privacy();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (parser2.getName().equals("active")) {
                    String activeName = parser2.getAttributeValue("", "name");
                    if (activeName == null) {
                        privacy.setDeclineActiveList(true);
                        continue;
                    }
                    privacy.setActiveName(activeName);
                    continue;
                }
                if (parser2.getName().equals("default")) {
                    String defaultName = parser2.getAttributeValue("", "name");
                    if (defaultName == null) {
                        privacy.setDeclineDefaultList(true);
                        continue;
                    }
                    privacy.setDefaultName(defaultName);
                    continue;
                }
                if (!parser2.getName().equals("list")) continue;
                PrivacyProvider.parseList(parser2, privacy);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("query")) continue;
            done = true;
        }
        return privacy;
    }

    private static void parseList(XmlPullParser parser2, Privacy privacy) throws XmlPullParserException, IOException {
        boolean done = false;
        String listName = parser2.getAttributeValue("", "name");
        ArrayList<PrivacyItem> items = new ArrayList<PrivacyItem>();
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (!parser2.getName().equals("item")) continue;
                items.add(PrivacyProvider.parseItem(parser2));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("list")) continue;
            done = true;
        }
        privacy.setPrivacyList(listName, items);
    }

    private static PrivacyItem parseItem(XmlPullParser parser2) throws XmlPullParserException, IOException {
        PrivacyItem item;
        boolean allow;
        String actionValue = parser2.getAttributeValue("", "action");
        UInt32 order = ParserUtils.getUInt32Attribute(parser2, "order");
        String type = parser2.getAttributeValue("", "type");
        switch (actionValue) {
            case "allow": {
                allow = true;
                break;
            }
            case "deny": {
                allow = false;
                break;
            }
            default: {
                throw new IOException("Unknown action value '" + actionValue + "'");
            }
        }
        if (type != null) {
            String value2 = parser2.getAttributeValue("", "value");
            item = new PrivacyItem(PrivacyItem.Type.valueOf(type), value2, allow, order);
        } else {
            item = new PrivacyItem(allow, order);
        }
        PrivacyProvider.parseItemChildElements(parser2, item);
        return item;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseItemChildElements(XmlPullParser parser2, PrivacyItem privacyItem) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "iq": {
                            privacyItem.setFilterIQ(true);
                            break block0;
                        }
                        case "message": {
                            privacyItem.setFilterMessage(true);
                            break block0;
                        }
                        case "presence-in": {
                            privacyItem.setFilterPresenceIn(true);
                            break block0;
                        }
                        case "presence-out": {
                            privacyItem.setFilterPresenceOut(true);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }
}

