/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.LocalVarImpl;
import io.quarkus.gizmo2.impl.Util;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

final class LocalVarAllocator
extends Item {
    private final LocalVarImpl localVar;
    private Label startScope;
    private Label endScope;

    LocalVarAllocator(LocalVarImpl localVar) {
        this.localVar = localVar;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        int slot = cb.allocateLocal(Util.actualKindOf(this.localVar.typeKind()));
        this.startScope = cb.newBoundLabel();
        this.endScope = block.endLabel();
        cb.localVariable(slot, this.localVar.name(), this.localVar.type(), this.startScope, this.endScope);
        GenericType gt = this.localVar.genericType();
        if (!gt.isRaw()) {
            cb.localVariableType(slot, this.localVar.name(), Util.signatureOf(gt), this.startScope, this.endScope);
        }
        this.localVar.slot = slot;
    }

    @Override
    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
        if (this.localVar.genericType().hasAnnotations(retention)) {
            Util.computeAnnotations(this.localVar.genericType(), retention, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)this.startScope, (Label)this.endScope, (int)this.localVar.slot))), annotations, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
    }
}

