/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.LibNFD;

@NativeType(value="struct nfdpathset_t")
public class NFDPathSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    public NFDPathSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NFDPathSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static NFDPathSet malloc() {
        return (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NFDPathSet calloc() {
        return (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NFDPathSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NFDPathSet create(long address) {
        return (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)address);
    }

    @Nullable
    public static NFDPathSet createSafe(long address) {
        return address == 0L ? null : (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NFDPathSet.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NFDPathSet.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NFDPathSet.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDPathSet.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NFDPathSet.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NFDPathSet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NFDPathSet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NFDPathSet mallocStack() {
        return NFDPathSet.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NFDPathSet callocStack() {
        return NFDPathSet.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NFDPathSet mallocStack(MemoryStack stack) {
        return NFDPathSet.malloc(stack);
    }

    @Deprecated
    public static NFDPathSet callocStack(MemoryStack stack) {
        return NFDPathSet.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NFDPathSet.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NFDPathSet.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NFDPathSet.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NFDPathSet.calloc(capacity, stack);
    }

    public static NFDPathSet malloc(MemoryStack stack) {
        return (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NFDPathSet calloc(MemoryStack stack) {
        return (NFDPathSet)NFDPathSet.wrap(NFDPathSet.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NFDPathSet.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NFDPathSet.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    static {
        LibNFD.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = NFDPathSet.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<NFDPathSet, Buffer>
    implements NativeResource {
        private static final NFDPathSet ELEMENT_FACTORY = NFDPathSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NFDPathSet getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

