/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractManagedProvider;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemBuilderFactory;
import org.openhab.core.items.ItemFactory;
import org.openhab.core.items.ItemProvider;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.dto.GroupFunctionDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ItemProvider.class, ManagedItemProvider.class})
public class ManagedItemProvider
extends AbstractManagedProvider<Item, String, PersistedItem>
implements ItemProvider {
    private final Logger logger = LoggerFactory.getLogger(ManagedItemProvider.class);
    private final ItemBuilderFactory itemBuilderFactory;
    private final Map<String, PersistedItem> failedToCreate = new ConcurrentHashMap<String, PersistedItem>();

    @Activate
    public ManagedItemProvider(@Reference StorageService storageService, @Reference ItemBuilderFactory itemBuilderFactory) {
        super(storageService);
        this.itemBuilderFactory = itemBuilderFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @Nullable Item remove(String key) {
        Item item = (Item)this.get(key);
        Item item2 = item;
        if (item2 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item2;
            GroupItem cfr_ignored_0 = (GroupItem)item2;
            this.removeGroupNameFromMembers((GroupItem)groupItem);
        }
        return (Item)super.remove(key);
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable Item remove(String itemName, boolean recursive) {
        Item item;
        Item item2 = (Item)this.get(itemName);
        if (recursive && (item = item2) instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item;
            GroupItem cfr_ignored_0 = (GroupItem)item;
            for (String member : this.getMemberNamesRecursively((GroupItem)groupItem, this.getAll())) {
                this.remove(member);
            }
        }
        if (item2 != null) {
            this.remove(item2.getName());
            return item2;
        }
        return null;
    }

    @Override
    public void add(Item element) {
        if (!ItemUtil.isValidItemName(element.getName())) {
            throw new IllegalArgumentException("The item name '" + element.getName() + "' is invalid.");
        }
        super.add(element);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getMemberNamesRecursively(GroupItem groupItem, Collection<Item> allItems) {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Item item : allItems) {
            void groupItem1;
            if (!item.getGroupNames().contains(groupItem.getName())) continue;
            memberNames.add(item.getName());
            Item item2 = item;
            if (!(item2 instanceof GroupItem)) continue;
            GroupItem cfr_ignored_0 = (GroupItem)item2;
            GroupItem cfr_ignored_1 = (GroupItem)item2;
            memberNames.addAll(this.getMemberNamesRecursively((GroupItem)groupItem1, allItems));
        }
        return memberNames;
    }

    private Set<Item> getMembers(GroupItem groupItem, Collection<Item> allItems) {
        HashSet<Item> members = new HashSet<Item>();
        for (Item item : allItems) {
            if (!item.getGroupNames().contains(groupItem.getName())) continue;
            members.add(item);
        }
        return members;
    }

    private @Nullable Item createItem(String itemType, String itemName) {
        try {
            return this.itemBuilderFactory.newItemBuilder(itemType, itemName).build();
        }
        catch (IllegalStateException e) {
            this.logger.debug("Couldn't create item '{}' of type '{}'", (Object)itemName, (Object)itemType);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeGroupNameFromMembers(GroupItem groupItem) {
        Set<Item> members = this.getMembers(groupItem, this.getAll());
        for (Item member : members) {
            void item;
            Item item2 = member;
            if (!(item2 instanceof GenericItem)) continue;
            GenericItem cfr_ignored_0 = (GenericItem)item2;
            GenericItem cfr_ignored_1 = (GenericItem)item2;
            item.removeGroupName(groupItem.getUID());
            this.update(member);
        }
    }

    private String toItemFactoryName(Item item) {
        return item.getType();
    }

    /*
     * WARNING - void declaration
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        if (!this.failedToCreate.isEmpty()) {
            Iterator<Map.Entry<String, PersistedItem>> iterator = this.failedToCreate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PersistedItem> entry = iterator.next();
                String itemName = entry.getKey();
                PersistedItem persistedItem = entry.getValue();
                Item item = itemFactory.createItem(persistedItem.itemType, itemName);
                Item item2 = item;
                if (item2 instanceof GenericItem) {
                    void genericItem;
                    GenericItem cfr_ignored_0 = (GenericItem)item2;
                    GenericItem cfr_ignored_1 = (GenericItem)item2;
                    iterator.remove();
                    this.configureItem(persistedItem, (GenericItem)genericItem);
                    this.notifyListenersAboutAddedElement(item);
                    continue;
                }
                this.logger.debug("The added item factory '{}' still could not instantiate item '{}'.", (Object)itemFactory, (Object)itemName);
            }
            if (this.failedToCreate.isEmpty()) {
                this.logger.info("Finished loading the items which could not have been created before.");
            }
        }
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
    }

    @Override
    protected String getStorageName() {
        return Item.class.getName();
    }

    @Override
    protected String keyToString(String key) {
        return key;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected @Nullable Item toElement(String itemName, PersistedItem persistedItem) {
        Item item;
        Object baseItemType;
        if ("Group".equals(persistedItem.itemType)) {
            baseItemType = persistedItem.baseItemType;
            if (baseItemType != null) {
                Item baseItem = this.createItem((String)baseItemType, itemName);
                if (persistedItem.functionName != null) {
                    GroupFunction function = this.getGroupFunction(persistedItem, baseItem);
                    item = new GroupItem(itemName, baseItem, function);
                } else {
                    item = new GroupItem(itemName, baseItem, new GroupFunction.Equality());
                }
            } else {
                item = new GroupItem(itemName);
            }
        } else {
            item = this.createItem(persistedItem.itemType, itemName);
        }
        Item item2 = item;
        if (item2 instanceof GenericItem) {
            void genericItem;
            baseItemType = (GenericItem)item2;
            GenericItem cfr_ignored_0 = (GenericItem)item2;
            this.configureItem(persistedItem, (GenericItem)genericItem);
        }
        if (item == null) {
            this.failedToCreate.put(itemName, persistedItem);
            this.logger.debug("Couldn't restore item '{}' of type '{}' ~\u00a0there is no appropriate ItemFactory available.", (Object)itemName, (Object)persistedItem.itemType);
        }
        return item;
    }

    private GroupFunction getGroupFunction(PersistedItem persistedItem, @Nullable Item baseItem) {
        GroupFunctionDTO functionDTO = new GroupFunctionDTO();
        functionDTO.name = persistedItem.functionName;
        if (persistedItem.functionParams != null) {
            functionDTO.params = persistedItem.functionParams.toArray(new String[persistedItem.functionParams.size()]);
        }
        return ItemDTOMapper.mapFunction(baseItem, functionDTO);
    }

    private void configureItem(PersistedItem persistedItem, GenericItem item) {
        Set<String> tags;
        List<String> groupNames = persistedItem.groupNames;
        if (groupNames != null) {
            for (String groupName : groupNames) {
                item.addGroupName(groupName);
            }
        }
        if ((tags = persistedItem.tags) != null) {
            for (String tag : tags) {
                item.addTag(tag);
            }
        }
        item.setLabel(persistedItem.label);
        item.setCategory(persistedItem.category);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected PersistedItem toPersistableElement(Item item) {
        PersistedItem persistedItem = new PersistedItem(item instanceof GroupItem ? "Group" : this.toItemFactoryName(item));
        Item item2 = item;
        if (item2 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item2;
            GroupItem cfr_ignored_0 = (GroupItem)item2;
            String baseItemType = null;
            Item baseItem = groupItem.getBaseItem();
            if (baseItem != null) {
                baseItemType = this.toItemFactoryName(baseItem);
            }
            persistedItem.baseItemType = baseItemType;
            this.addFunctionToPersisedItem(persistedItem, (GroupItem)groupItem);
        }
        persistedItem.label = item.getLabel();
        persistedItem.groupNames = new ArrayList<String>(item.getGroupNames());
        persistedItem.tags = new HashSet<String>(item.getTags());
        persistedItem.category = item.getCategory();
        return persistedItem;
    }

    private void addFunctionToPersisedItem(PersistedItem persistedItem, GroupItem groupItem) {
        GroupFunctionDTO functionDTO;
        if (groupItem.getFunction() != null && (functionDTO = ItemDTOMapper.mapFunction(groupItem.getFunction())) != null) {
            persistedItem.functionName = functionDTO.name;
            if (functionDTO.params != null) {
                persistedItem.functionParams = Arrays.asList(functionDTO.params);
            }
        }
    }

    public static class PersistedItem {
        public @Nullable String baseItemType;
        public @Nullable List<String> groupNames;
        public String itemType;
        public @Nullable Set<String> tags;
        public @Nullable String label;
        public @Nullable String category;
        public @Nullable String functionName;
        public @Nullable List<String> functionParams;
        public @Nullable String dimension;

        public PersistedItem(String itemType) {
            this.itemType = itemType;
        }
    }
}

