/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.server.ui;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerContentCloseListener;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"JUPYTER_TOOL_WINDOW_ID", "", "getJupyterToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateJupyterToolWindow", "attachJupyterServerContentCloseListener", "", "content", "Lcom/intellij/ui/content/Content;", "sessionName", "handler", "Lcom/intellij/execution/process/KillableProcessHandler;", "notifyJupyterServerStarted", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "notifyJupyterServerTerminated", "isDestroyed", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerToolWindow.kt\ncom/intellij/jupyter/core/jupyter/server/ui/JupyterServerToolWindowKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1869#2,2:105\n*S KotlinDebug\n*F\n+ 1 JupyterServerToolWindow.kt\ncom/intellij/jupyter/core/jupyter/server/ui/JupyterServerToolWindowKt\n*L\n100#1:105,2\n*E\n"})
public final class JupyterServerToolWindowKt {
    @NotNull
    private static final String JUPYTER_TOOL_WINDOW_ID = "Jupyter";

    @Nullable
    public static final ToolWindow getJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow(JUPYTER_TOOL_WINDOW_ID);
    }

    @NotNull
    public static final ToolWindow getOrCreateJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(JUPYTER_TOOL_WINDOW_ID);
        if (toolWindow == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
            ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
            toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(JUPYTER_TOOL_WINDOW_ID, toolWindowAnchor2, null, false, true, false, false, null, null, null, 1004, null));
        }
        ToolWindow toolWindow2 = toolWindow;
        toolWindow2.setIcon(JupyterCoreIcons.JupyterToolWindow);
        return toolWindow2;
    }

    public static final void attachJupyterServerContentCloseListener(@NotNull Content content, @NotNull Project project, @Nls @NotNull String sessionName, @NotNull KillableProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        new JupyterServerContentCloseListener(content, project, sessionName, handler2);
    }

    public static final void notifyJupyterServerStarted(@NotNull Project project, @NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
        URI initialUri = connectionParameters.getUri();
        String initialUriString = initialUri.toASCIIString();
        String shareableUri = connectionParameters.getHttpParams().toUrl();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)initialUriString);
        objectArray[0] = initialUriString;
        String message = JupyterBundle.message("jupyter.server.started.at", objectArray);
        Object[] objectArray2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.tag((String)"a").attr("href", shareableUri).addText(initialUriString).toString(), (String)"toString(...)");
        String messageWithURL = JupyterBundle.message("jupyter.server.started.at", objectArray2);
        JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP().createNotification(messageWithURL, NotificationType.INFORMATION).setDisplayId("jupyter.server.started").setListener(NotificationListener.URL_OPENING_LISTENER).notify(project);
        JupyterNotification.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP().createNotification(message, NotificationType.INFORMATION).setDisplayId("jupyter.server.started").addAction((AnAction)new BrowseNotificationAction(JupyterBundle.message("Jupyter.open.in.browser", new Object[0]), shareableUri)).notify(project);
    }

    public static final void notifyJupyterServerTerminated(@NotNull Project project, boolean isDestroyed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair pair = isDestroyed ? TuplesKt.to((Object)JupyterBundle.message("jupyter.server.stopped", new Object[0]), (Object)"jupyter.server.started") : TuplesKt.to((Object)JupyterBundle.message("jupyter.server.detached", new Object[0]), (Object)"jupyter.server.detached");
        String message = (String)pair.component1();
        String displayId = (String)pair.component2();
        Object[] objectArray = new NotificationGroup[]{JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP(), JupyterNotification.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationGroup it = (NotificationGroup)element$iv;
            boolean bl = false;
            it.createNotification(message, NotificationType.INFORMATION).setDisplayId(displayId).notify(project);
        }
    }
}

