/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.StateStoreNode;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StoreFactory;

public class GlobalStoreNode<KIn, VIn, S extends StateStore>
extends StateStoreNode<S> {
    private final String sourceName;
    private final String topic;
    private final ConsumedInternal<KIn, VIn> consumed;
    private final String processorName;
    private final ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier;

    public GlobalStoreNode(StoreFactory storeBuilder, String sourceName, String topic, ConsumedInternal<KIn, VIn> consumed, String processorName, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        super(storeBuilder);
        this.sourceName = sourceName;
        this.topic = topic;
        this.consumed = consumed;
        this.processorName = processorName;
        this.stateUpdateSupplier = stateUpdateSupplier;
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        this.storeBuilder.withLoggingDisabled();
        topologyBuilder.addGlobalStore(this.storeBuilder, this.sourceName, this.consumed.timestampExtractor(), this.consumed.keyDeserializer(), this.consumed.valueDeserializer(), this.topic, this.processorName, this.stateUpdateSupplier);
    }

    @Override
    public String toString() {
        return "GlobalStoreNode{sourceName='" + this.sourceName + '\'' + ", topic='" + this.topic + '\'' + ", processorName='" + this.processorName + '\'' + "} ";
    }
}

