/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.lang.invoke.MethodHandles;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.GetSchemaApi;
import org.apache.solr.client.api.model.SchemaInfoResponse;
import org.apache.solr.client.api.model.SchemaNameResponse;
import org.apache.solr.client.api.model.SchemaSimilarityResponse;
import org.apache.solr.client.api.model.SchemaUniqueKeyResponse;
import org.apache.solr.client.api.model.SchemaVersionResponse;
import org.apache.solr.client.api.model.SchemaZkVersionResponse;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSchema
extends JerseyResource
implements GetSchemaApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final IndexSchema indexSchema;
    protected final SolrCore solrCore;

    @Inject
    public GetSchema(SolrCore solrCore, IndexSchema indexSchema) {
        this.solrCore = solrCore;
        this.indexSchema = indexSchema;
    }

    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaInfoResponse getSchemaInfo() {
        SchemaInfoResponse response = this.instantiateJerseyResponse(SchemaInfoResponse.class);
        response.schema = this.indexSchema.getNamedPropertyValues();
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaNameResponse getSchemaName() throws Exception {
        SchemaNameResponse response = this.instantiateJerseyResponse(SchemaNameResponse.class);
        if (null == this.indexSchema.getSchemaName()) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Schema has no name");
        }
        response.name = this.indexSchema.getSchemaName();
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaSimilarityResponse getSchemaSimilarity() {
        SchemaSimilarityResponse response = this.instantiateJerseyResponse(SchemaSimilarityResponse.class);
        response.similarity = this.indexSchema.getSimilarityFactory().getNamedPropertyValues();
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaUniqueKeyResponse getSchemaUniqueKey() {
        SchemaUniqueKeyResponse response = this.instantiateJerseyResponse(SchemaUniqueKeyResponse.class);
        response.uniqueKey = this.indexSchema.getUniqueKeyField().getName();
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaVersionResponse getSchemaVersion() {
        SchemaVersionResponse response = this.instantiateJerseyResponse(SchemaVersionResponse.class);
        response.version = this.indexSchema.getVersion();
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaZkVersionResponse getSchemaZkVersion(Integer refreshIfBelowVersion) throws Exception {
        SchemaZkVersionResponse response = this.instantiateJerseyResponse(SchemaZkVersionResponse.class);
        int zkVersion = -1;
        if (this.solrCore.getLatestSchema() instanceof ManagedIndexSchema) {
            ManagedIndexSchema managed = (ManagedIndexSchema)this.solrCore.getLatestSchema();
            zkVersion = managed.getSchemaZkVersion();
            if (refreshIfBelowVersion != -1 && zkVersion < refreshIfBelowVersion) {
                log.info("REFRESHING SCHEMA (refreshIfBelowVersion={}, currentVersion={}) before returning version!", (Object)refreshIfBelowVersion, (Object)zkVersion);
                ZkSolrResourceLoader zkSolrResourceLoader = (ZkSolrResourceLoader)this.solrCore.getResourceLoader();
                ZkIndexSchemaReader zkIndexSchemaReader = zkSolrResourceLoader.getZkIndexSchemaReader();
                managed = zkIndexSchemaReader.refreshSchemaFromZk(refreshIfBelowVersion);
                zkVersion = managed.getSchemaZkVersion();
            }
        }
        response.zkversion = zkVersion;
        return response;
    }
}

