/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class FeatureLogger {
    private final String fvCacheName;
    protected final FeatureFormat featureFormat;
    protected Boolean logAll;

    protected FeatureLogger(String fvCacheName, FeatureFormat f, Boolean logAll) {
        this.fvCacheName = fvCacheName;
        this.featureFormat = f;
        this.logAll = logAll;
    }

    public boolean log(int docid, LTRScoringQuery scoringQuery, SolrIndexSearcher searcher, LTRScoringQuery.FeatureInfo[] featuresInfo) {
        String featureVector = this.makeFeatureVector(featuresInfo);
        if (featureVector == null) {
            return false;
        }
        return null != searcher.cacheInsert(this.fvCacheName, (Object)FeatureLogger.fvCacheKey(scoringQuery, docid), (Object)featureVector);
    }

    public abstract String makeFeatureVector(LTRScoringQuery.FeatureInfo[] var1);

    private static int fvCacheKey(LTRScoringQuery scoringQuery, int docid) {
        return scoringQuery.hashCode() + 31 * docid;
    }

    public String getFeatureVector(int docid, LTRScoringQuery scoringQuery, SolrIndexSearcher searcher) {
        return (String)searcher.cacheLookup(this.fvCacheName, (Object)FeatureLogger.fvCacheKey(scoringQuery, docid));
    }

    public Boolean isLoggingAll() {
        return this.logAll;
    }

    public void setLogAll(Boolean logAll) {
        this.logAll = logAll;
    }

    public static enum FeatureFormat {
        DENSE,
        SPARSE;

    }
}

