/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tokenbinding;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenBindingMessageParser
extends ProtocolMessageParser<TokenBindingMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public TokenBindingMessageParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, version, config);
    }

    @Override
    protected TokenBindingMessage parseMessageContent() {
        TokenBindingMessage message = new TokenBindingMessage();
        message.setTokenbindingsLength(this.parseIntField(2));
        LOGGER.debug("TokenbindingLength:" + message.getTokenbindingsLength().getValue());
        message.setTokenbindingType(this.parseByteField(1));
        LOGGER.debug("TokenBindingType:" + message.getTokenbindingType().getValue());
        message.setKeyParameter(this.parseByteField(1));
        LOGGER.debug("KeyParameter:" + message.getKeyParameter().getValue());
        TokenBindingKeyParameters keyParameter = TokenBindingKeyParameters.getTokenBindingKeyParameter((Byte)message.getKeyParameter().getValue());
        message.setKeyLength(this.parseIntField(2));
        LOGGER.debug("KeyLength:" + message.getKeyLength().getValue());
        if (keyParameter.equals((Object)TokenBindingKeyParameters.ECDSAP256)) {
            message.setPointLength(this.parseIntField(1));
            LOGGER.debug("PointLength:" + message.getPointLength().getValue());
            message.setPoint(this.parseByteArrayField((Integer)message.getPointLength().getValue()));
            LOGGER.debug("Point:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getPoint().getValue())));
        } else {
            message.setModulusLength(this.parseIntField(2));
            message.setModulus(this.parseByteArrayField((Integer)message.getModulusLength().getValue()));
            message.setPublicExponentLength(this.parseIntField(1));
            message.setPublicExponent(this.parseByteArrayField((Integer)message.getPublicExponentLength().getValue()));
        }
        message.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength:" + message.getSignatureLength().getValue());
        message.setSignature(this.parseByteArrayField((Integer)message.getSignatureLength().getValue()));
        LOGGER.debug("Signature:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getSignature().getValue())));
        message.setExtensionLength(this.parseIntField(2));
        LOGGER.debug("ExtensionLength:" + message.getExtensionLength().getValue());
        message.setExtensionBytes(this.parseByteArrayField((Integer)message.getExtensionLength().getValue()));
        LOGGER.debug("Extensions:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getExtensionBytes().getValue())));
        return message;
    }
}

