/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ZoomAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(ZoomAction.class);
    protected double zoomStep;
    public static final String ZOOM_IN = "ca.sqlpower.architect.swingui.ZoomAction.ZOOM_IN";
    public static final String ZOOM_OUT = "ca.sqlpower.architect.swingui.ZoomAction.ZOOM_OUT";
    public static final String ZOOM_ALL = "ca.sqlpower.architect.swingui.ZoomAction.ZOOM_ALL";

    public ZoomAction(ArchitectSwingSession session, PlayPen playpen, double amount) {
        super(session, playpen, amount > 0.0 ? Messages.getString("ZoomAction.zoomInActionName") : Messages.getString("ZoomAction.zoomOutActionName"), amount > 0.0 ? Messages.getString("ZoomAction.zoomInActionDescription") : Messages.getString("ZoomAction.zoomOutActionDescription"), amount > 0.0 ? "zoom_in" : "zoom_out");
        this.zoomStep = amount;
        if (amount > 0.0) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
    }

    public ZoomAction(ArchitectFrame frame, double amount) {
        super(frame, amount > 0.0 ? Messages.getString("ZoomAction.zoomInActionName") : Messages.getString("ZoomAction.zoomOutActionName"), amount > 0.0 ? Messages.getString("ZoomAction.zoomInActionDescription") : Messages.getString("ZoomAction.zoomOutActionDescription"), amount > 0.0 ? "zoom_in" : "zoom_out");
        this.zoomStep = amount;
        if (amount > 0.0) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("oldZoom=" + this.getPlaypen().getZoom() + ",zoomStep=" + this.zoomStep));
        this.getPlaypen().setZoom(this.getPlaypen().getZoom() * Math.pow(2.0, this.zoomStep));
        logger.debug((Object)("newZoom=" + this.getPlaypen().getZoom()));
        Rectangle scrollTo = null;
        Iterator<PlayPenComponent> it = this.getPlaypen().getSelectedItems().iterator();
        while (it.hasNext()) {
            Rectangle bounds = it.next().getBounds();
            logger.debug((Object)("new rectangle, bounds: " + bounds));
            if (scrollTo == null) {
                scrollTo = new Rectangle(bounds);
                continue;
            }
            logger.debug((Object)("added rectangles, new bounds: " + scrollTo));
            scrollTo.add(bounds);
        }
        if (scrollTo != null && !scrollTo.isEmpty()) {
            this.getPlaypen().zoomRect(scrollTo);
            this.getPlaypen().scrollRectToVisible(scrollTo);
        }
    }
}

