/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSVersion;
import com.microsoft.sqlserver.jdbc.Util;

final class StreamDone
implements StreamPacket {
    private short status;
    private int rowCount;
    private int rowCountHigh;
    private int retStat;
    static final short CMD_SELECT = 193;
    static final short CMD_EXECUTE = 224;
    static final short CMD_DBCC = 230;
    private short curCmd;
    private boolean isRetStatSet;
    private byte packetType;

    StreamDone(byte by) {
        this.packetType = by;
    }

    void setData(byte by, byte[] byArray, int n, TDSVersion tDSVersion) {
        this.packetType = by;
        int n2 = n;
        this.status = Util.readShort(byArray, n2);
        this.curCmd = Util.readShort(byArray, n2 += 2);
        this.rowCount = Util.readInt(byArray, n2 += 2);
        n2 += 4;
        if (tDSVersion.isYukonOrLater()) {
            this.rowCountHigh = Util.readInt(byArray, n2);
            n2 += 4;
        }
    }

    final byte getPacketType() {
        return this.packetType;
    }

    final int getRowCount() {
        return this.hasCount() ? this.rowCount : 0;
    }

    final short getCurCmd() {
        return this.curCmd;
    }

    final boolean isFinal() {
        return (this.status & 1) == 0;
    }

    final boolean isError() {
        return (this.status & 2) != 0;
    }

    final boolean hasCount() {
        return (this.status & 0x10) != 0;
    }

    final boolean moreResults() {
        return (this.status & 1) != 0;
    }

    final boolean wasCanceled() {
        return (this.status & 0x20) != 0;
    }

    final boolean wasRPCInBatch() {
        return (this.status & 0x80) != 0;
    }

    final boolean haveRetStat() {
        return this.isRetStatSet;
    }

    final void setRetStat(int n) {
        this.retStat = n;
        this.isRetStatSet = true;
    }

    final int getRetStat() {
        return this.retStat;
    }
}

