/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public class DefaultJvmVendorSpec
extends JvmVendorSpec
implements Predicate<JvmInstallationMetadata>,
Serializable {
    private static final JvmVendorSpec ANY = new DefaultJvmVendorSpec();
    private final String match;
    private final JvmVendor.KnownJvmVendor matchingVendor;
    private transient Predicate<JvmVendor> matcher;
    private final String description;

    public static JvmVendorSpec matching(String match) {
        return new DefaultJvmVendorSpec(match, "vendor matching('" + match + "')");
    }

    public static JvmVendorSpec of(JvmVendor.KnownJvmVendor knownVendor) {
        return new DefaultJvmVendorSpec(knownVendor, knownVendor.asJvmVendor().getDisplayName());
    }

    public static JvmVendorSpec any() {
        return ANY;
    }

    private DefaultJvmVendorSpec(String match, String description) {
        this.match = match;
        this.matchingVendor = null;
        this.matcher = vendor -> StringUtils.containsIgnoreCase((String)vendor.getRawVendor(), (String)match);
        this.description = description;
    }

    private DefaultJvmVendorSpec(JvmVendor.KnownJvmVendor knownVendor, String description) {
        this.match = null;
        this.matchingVendor = knownVendor;
        this.matcher = vendor -> vendor.getKnownVendor() == this.matchingVendor;
        this.description = description;
    }

    private DefaultJvmVendorSpec() {
        this.match = null;
        this.matchingVendor = null;
        this.matcher = v -> true;
        this.description = "any vendor";
    }

    public String toCriteria() {
        if (this.match != null) {
            return this.match;
        }
        if (this.matchingVendor != null) {
            return this.matchingVendor.asJvmVendor().getKnownVendor().name();
        }
        throw new IllegalStateException("No matching vendor was specified");
    }

    @Override
    public boolean test(JvmInstallationMetadata metadata) {
        JvmVendor vendor = metadata.getVendor();
        return this.test(vendor);
    }

    @Override
    public boolean test(JvmVendor vendor) {
        return this.matcher.test(vendor);
    }

    @Override
    public boolean matches(String vendor) {
        return this.test(JvmVendor.fromString(vendor));
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJvmVendorSpec that = (DefaultJvmVendorSpec)o;
        return Objects.equal((Object)this.description, (Object)that.description);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.matcher = this.match != null ? vendor -> StringUtils.containsIgnoreCase((String)vendor.getRawVendor(), (String)this.match) : (this.matchingVendor != null ? vendor -> vendor.getKnownVendor() == this.matchingVendor : vendor -> true);
    }
}

