/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jruby.util.GenericMap;

public class WeakIdentityHashMap
extends GenericMap
implements Map {
    private static final float DEFAULT_RATIO = 0.75f;
    private static final Object NULL_KEY = new Object();
    private final ReferenceQueue queue = new ReferenceQueue();
    private Entry[] table;
    private int range;
    private float ratio;

    private static Object unmaskKey(Object key2) {
        if (key2 == NULL_KEY) {
            return null;
        }
        return key2;
    }

    private Object maskKey(Object key2) {
        if (key2 == null) {
            return NULL_KEY;
        }
        return key2;
    }

    private int index(int hash2) {
        return (hash2 & 0x7FFFFFF) % this.range;
    }

    public WeakIdentityHashMap() {
        this.clear(3);
    }

    public WeakIdentityHashMap(int size2) {
        this.clear(Math.max(3, Math.round((float)size2 / 0.75f)));
    }

    @Override
    public void clear() {
        this.clear(3);
    }

    private void clear(int size2) {
        this.range = size2;
        this.size = 0;
        this.ratio = 0.75f;
        this.table = new Entry[this.range];
    }

    private void expunge() {
        Entry e;
        while ((e = (Entry)this.queue.poll()) != null) {
            this.removeEntry(e);
        }
    }

    public Object get(Object key2) {
        Object masked_key = this.maskKey(key2);
        int hash2 = this.keyHash(masked_key);
        return this.get(hash2, masked_key);
    }

    private Object get(int hash2, Object masked_key) {
        int idx = this.index(hash2);
        this.expunge();
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash2, masked_key)) {
                return ent.value;
            }
            ent = ent.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key2) {
        Object masked_key = this.maskKey(key2);
        int hash2 = this.keyHash(masked_key);
        return this.containsKey(hash2, masked_key);
    }

    private boolean containsKey(int hash2, Object masked_key) {
        int idx = this.index(hash2);
        this.expunge();
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash2, masked_key)) {
                return true;
            }
            ent = ent.next;
        }
        return false;
    }

    public Object put(Object key2, Object value2) {
        Object masked_key = this.maskKey(key2);
        int hash2 = this.keyHash(masked_key);
        return this.put(hash2, masked_key, value2);
    }

    private Object put(int hash2, Object masked_key, Object value2) {
        int idx = this.index(hash2);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash2, masked_key)) {
                return ent.setValue(value2);
            }
            ent = ent.next;
        }
        this.expunge();
        if (1.0f * (float)this.size / (float)this.range > this.ratio) {
            this.grow();
            idx = this.index(hash2);
        }
        this.table[idx] = new Entry(hash2, masked_key, value2, this.table[idx], this.queue);
        ++this.size;
        return null;
    }

    public Object remove(Object key2) {
        key2 = this.maskKey(key2);
        int hash2 = this.keyHash(key2);
        return this.remove(hash2, key2);
    }

    public Object remove(int hash2, Object key2) {
        key2 = this.maskKey(key2);
        int idx = this.index(hash2);
        Entry entry = this.table[idx];
        if (entry != null) {
            if (entry.sameKey(hash2, key2)) {
                this.table[idx] = entry.next;
                --this.size;
                return entry.getValue();
            }
            Entry ahead = entry.next;
            while (ahead != null) {
                if (ahead.sameKey(hash2, key2)) {
                    entry.next = ahead.next;
                    --this.size;
                    return ahead.getValue();
                }
                entry = ahead;
                ahead = ahead.next;
            }
        }
        return null;
    }

    private void removeEntry(Entry ent) {
        int idx = this.index(ent.key_hash);
        Entry entry = this.table[idx];
        if (entry != null) {
            if (entry == ent) {
                this.table[idx] = entry.next;
                --this.size;
                return;
            }
            Entry ahead = entry.next;
            while (ahead != null) {
                if (ahead == ent) {
                    entry.next = ahead.next;
                    --this.size;
                    return;
                }
                entry = ahead;
                ahead = ahead.next;
            }
        }
        this.valueRemoved(ent.value);
    }

    protected void valueRemoved(Object value2) {
    }

    private void grow() {
        int old_range = this.range;
        Entry[] old_table = this.table;
        this.range = old_range * 2 + 1;
        this.table = new Entry[this.range];
        for (int i2 = 0; i2 < old_range; ++i2) {
            Entry entry = old_table[i2];
            while (entry != null) {
                Entry ahead = entry.next;
                int idx = this.index(entry.key_hash);
                entry.next = this.table[idx];
                this.table[idx] = entry;
                entry = ahead;
            }
        }
    }

    @Override
    protected Iterator entryIterator() {
        return new EntryIterator();
    }

    @Override
    protected final int keyHash(Object key2) {
        return System.identityHashCode(key2);
    }

    @Override
    protected final boolean keyEquals(Object key1, Object key2) {
        return key1 == key2;
    }

    @Override
    public int size() {
        this.expunge();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    class Entry
    extends WeakReference
    implements Map.Entry {
        private final int key_hash;
        private Entry next;
        private Object value;

        @Override
        public int hashCode() {
            return this.key_hash ^ WeakIdentityHashMap.this.valueHash(this.getValue());
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry ent = (Map.Entry)other;
                return this.getKey() == ent.getKey() && WeakIdentityHashMap.this.valueEquals(this.getValue(), ent.getValue());
            }
            return false;
        }

        Entry(int key_hash, Object masked_key, Object value2, Entry next2, ReferenceQueue q) {
            super(masked_key, q);
            this.key_hash = key_hash;
            this.value = value2;
            this.next = next2;
        }

        Object getMaskedKey() {
            return super.get();
        }

        public Object getKey() {
            return WeakIdentityHashMap.unmaskKey(this.getMaskedKey());
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value2) {
            Object result2 = this.value;
            this.value = value2;
            return result2;
        }

        boolean sameKey(int hash2, Object masked_key) {
            return this.getMaskedKey() == masked_key;
        }
    }

    final class EntryIterator
    implements Iterator {
        private int idx = 0;
        private Entry entry;

        EntryIterator() {
            WeakIdentityHashMap.this.expunge();
            this.entry = WeakIdentityHashMap.this.table[0];
            this.locateNext();
        }

        private void locateNext() {
            while (this.entry == null) {
                ++this.idx;
                if (this.idx == WeakIdentityHashMap.this.range) {
                    return;
                }
                this.entry = WeakIdentityHashMap.this.table[this.idx];
            }
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            Entry result2 = this.entry;
            if (result2 == null) {
                throw new NoSuchElementException();
            }
            this.entry = this.entry.next;
            this.locateNext();
            return result2;
        }

        @Override
        public void remove() {
            Entry remove = this.entry;
            WeakIdentityHashMap.this.expunge();
            this.entry = this.entry.next;
            this.locateNext();
            WeakIdentityHashMap.this.removeEntry(remove);
        }
    }
}

