/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Locale;
import net.bytebuddy.description.type.TypeDescription;
import org.hibernate.bytecode.enhance.spi.EnhancementException;

public class FeatureMismatchException
extends EnhancementException {
    private final String className;
    private final Feature mismatchedFeature;
    private final boolean previousValue;

    public FeatureMismatchException(String className, Feature mismatchedFeature, boolean previousValue) {
        super(String.format(Locale.ROOT, "Support for %s was enabled during enhancement, but `%s` was previously enhanced with that support %s.", FeatureMismatchException.featureText(mismatchedFeature), className, FeatureMismatchException.decode(previousValue)));
        this.className = className;
        this.mismatchedFeature = mismatchedFeature;
        this.previousValue = previousValue;
    }

    public String getClassName() {
        return this.className;
    }

    public Feature getMismatchedFeature() {
        return this.mismatchedFeature;
    }

    public boolean wasPreviouslyEnabled() {
        return this.previousValue;
    }

    public static void checkFeatureEnablement(TypeDescription managedCtClass, Feature feature, boolean currentlyEnabled, boolean previouslyEnabled) {
        if (currentlyEnabled != previouslyEnabled) {
            throw new FeatureMismatchException(managedCtClass.getName(), feature, previouslyEnabled);
        }
    }

    private static String featureText(Feature mismatchedFeature) {
        return switch (mismatchedFeature.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "inline dirty checking";
            case 1 -> "bidirectional association management";
        };
    }

    private static String decode(boolean previousValue) {
        return previousValue ? "enabled" : "disabled";
    }

    public static enum Feature {
        DIRTY_CHECK,
        ASSOCIATION_MANAGEMENT;

    }
}

