/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.io.IOException;
import java.util.BitSet;
import org.logstash.ackedqueue.Checkpoint;
import org.logstash.ackedqueue.Page;
import org.logstash.ackedqueue.Queue;
import org.logstash.ackedqueue.io.PageIO;

class PageFactory {
    PageFactory() {
    }

    public static Page newHeadPage(int pageNum, Queue queue, PageIO pageIO) {
        return new Page(pageNum, queue, 0L, 0, 0L, new BitSet(), pageIO, true);
    }

    public static Page newHeadPage(Checkpoint checkpoint, Queue queue, PageIO pageIO) throws IOException {
        Page p = new Page(checkpoint.getPageNum(), queue, checkpoint.getMinSeqNum(), checkpoint.getElementCount(), checkpoint.getFirstUnackedSeqNum(), new BitSet(), pageIO, true);
        try {
            assert (checkpoint.getMinSeqNum() == pageIO.getMinSeqNum() && checkpoint.getElementCount() == pageIO.getElementCount()) : String.format("checkpoint minSeqNum=%d or elementCount=%d is different than pageIO minSeqNum=%d or elementCount=%d", checkpoint.getMinSeqNum(), checkpoint.getElementCount(), pageIO.getMinSeqNum(), pageIO.getElementCount());
            if (checkpoint.getFirstUnackedSeqNum() > checkpoint.getMinSeqNum()) {
                p.ackedSeqNums.flip(0, (int)(checkpoint.getFirstUnackedSeqNum() - checkpoint.getMinSeqNum()));
            }
            return p;
        }
        catch (Exception e) {
            p.close();
            throw e;
        }
    }

    public static Page newTailPage(Checkpoint checkpoint, Queue queue, PageIO pageIO) throws IOException {
        Page p = new Page(checkpoint.getPageNum(), queue, checkpoint.getMinSeqNum(), checkpoint.getElementCount(), checkpoint.getFirstUnackedSeqNum(), new BitSet(), pageIO, false);
        try {
            if (checkpoint.getFirstUnackedSeqNum() > checkpoint.getMinSeqNum()) {
                p.ackedSeqNums.flip(0, (int)(checkpoint.getFirstUnackedSeqNum() - checkpoint.getMinSeqNum()));
            }
            return p;
        }
        catch (Exception e) {
            p.close();
            throw e;
        }
    }
}

