/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_caps_limits_t")
public class BGFXCapsLimits
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXDRAWCALLS;
    public static final int MAXBLITS;
    public static final int MAXTEXTURESIZE;
    public static final int MAXTEXTURELAYERS;
    public static final int MAXVIEWS;
    public static final int MAXFRAMEBUFFERS;
    public static final int MAXFBATTACHMENTS;
    public static final int MAXPROGRAMS;
    public static final int MAXSHADERS;
    public static final int MAXTEXTURES;
    public static final int MAXTEXTURESAMPLERS;
    public static final int MAXCOMPUTEBINDINGS;
    public static final int MAXVERTEXLAYOUTS;
    public static final int MAXVERTEXSTREAMS;
    public static final int MAXINDEXBUFFERS;
    public static final int MAXVERTEXBUFFERS;
    public static final int MAXDYNAMICINDEXBUFFERS;
    public static final int MAXDYNAMICVERTEXBUFFERS;
    public static final int MAXUNIFORMS;
    public static final int MAXOCCLUSIONQUERIES;
    public static final int MAXENCODERS;
    public static final int MINRESOURCECBSIZE;
    public static final int TRANSIENTVBSIZE;
    public static final int TRANSIENTIBSIZE;

    public BGFXCapsLimits(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXCapsLimits.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int maxDrawCalls() {
        return BGFXCapsLimits.nmaxDrawCalls(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxBlits() {
        return BGFXCapsLimits.nmaxBlits(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTextureSize() {
        return BGFXCapsLimits.nmaxTextureSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTextureLayers() {
        return BGFXCapsLimits.nmaxTextureLayers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxViews() {
        return BGFXCapsLimits.nmaxViews(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFrameBuffers() {
        return BGFXCapsLimits.nmaxFrameBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFBAttachments() {
        return BGFXCapsLimits.nmaxFBAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPrograms() {
        return BGFXCapsLimits.nmaxPrograms(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxShaders() {
        return BGFXCapsLimits.nmaxShaders(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTextures() {
        return BGFXCapsLimits.nmaxTextures(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxTextureSamplers() {
        return BGFXCapsLimits.nmaxTextureSamplers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxComputeBindings() {
        return BGFXCapsLimits.nmaxComputeBindings(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexLayouts() {
        return BGFXCapsLimits.nmaxVertexLayouts(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexStreams() {
        return BGFXCapsLimits.nmaxVertexStreams(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxIndexBuffers() {
        return BGFXCapsLimits.nmaxIndexBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxVertexBuffers() {
        return BGFXCapsLimits.nmaxVertexBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDynamicIndexBuffers() {
        return BGFXCapsLimits.nmaxDynamicIndexBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDynamicVertexBuffers() {
        return BGFXCapsLimits.nmaxDynamicVertexBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxUniforms() {
        return BGFXCapsLimits.nmaxUniforms(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxOcclusionQueries() {
        return BGFXCapsLimits.nmaxOcclusionQueries(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxEncoders() {
        return BGFXCapsLimits.nmaxEncoders(this.address());
    }

    @NativeType(value="uint32_t")
    public int minResourceCbSize() {
        return BGFXCapsLimits.nminResourceCbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientVbSize() {
        return BGFXCapsLimits.ntransientVbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientIbSize() {
        return BGFXCapsLimits.ntransientIbSize(this.address());
    }

    public static BGFXCapsLimits create(long address) {
        return (BGFXCapsLimits)BGFXCapsLimits.wrap(BGFXCapsLimits.class, (long)address);
    }

    @Nullable
    public static BGFXCapsLimits createSafe(long address) {
        return address == 0L ? null : (BGFXCapsLimits)BGFXCapsLimits.wrap(BGFXCapsLimits.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXCapsLimits.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXCapsLimits.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int nmaxDrawCalls(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDRAWCALLS);
    }

    public static int nmaxBlits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXBLITS);
    }

    public static int nmaxTextureSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXTEXTURESIZE);
    }

    public static int nmaxTextureLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXTEXTURELAYERS);
    }

    public static int nmaxViews(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXVIEWS);
    }

    public static int nmaxFrameBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXFRAMEBUFFERS);
    }

    public static int nmaxFBAttachments(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXFBATTACHMENTS);
    }

    public static int nmaxPrograms(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPROGRAMS);
    }

    public static int nmaxShaders(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXSHADERS);
    }

    public static int nmaxTextures(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXTEXTURES);
    }

    public static int nmaxTextureSamplers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXTEXTURESAMPLERS);
    }

    public static int nmaxComputeBindings(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXCOMPUTEBINDINGS);
    }

    public static int nmaxVertexLayouts(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXVERTEXLAYOUTS);
    }

    public static int nmaxVertexStreams(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXVERTEXSTREAMS);
    }

    public static int nmaxIndexBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXINDEXBUFFERS);
    }

    public static int nmaxVertexBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXVERTEXBUFFERS);
    }

    public static int nmaxDynamicIndexBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDYNAMICINDEXBUFFERS);
    }

    public static int nmaxDynamicVertexBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDYNAMICVERTEXBUFFERS);
    }

    public static int nmaxUniforms(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXUNIFORMS);
    }

    public static int nmaxOcclusionQueries(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXOCCLUSIONQUERIES);
    }

    public static int nmaxEncoders(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXENCODERS);
    }

    public static int nminResourceCbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINRESOURCECBSIZE);
    }

    public static int ntransientVbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTVBSIZE);
    }

    public static int ntransientIbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTIBSIZE);
    }

    static {
        Struct.Layout layout = BGFXCapsLimits.__struct((Struct.Member[])new Struct.Member[]{BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4), BGFXCapsLimits.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXDRAWCALLS = layout.offsetof(0);
        MAXBLITS = layout.offsetof(1);
        MAXTEXTURESIZE = layout.offsetof(2);
        MAXTEXTURELAYERS = layout.offsetof(3);
        MAXVIEWS = layout.offsetof(4);
        MAXFRAMEBUFFERS = layout.offsetof(5);
        MAXFBATTACHMENTS = layout.offsetof(6);
        MAXPROGRAMS = layout.offsetof(7);
        MAXSHADERS = layout.offsetof(8);
        MAXTEXTURES = layout.offsetof(9);
        MAXTEXTURESAMPLERS = layout.offsetof(10);
        MAXCOMPUTEBINDINGS = layout.offsetof(11);
        MAXVERTEXLAYOUTS = layout.offsetof(12);
        MAXVERTEXSTREAMS = layout.offsetof(13);
        MAXINDEXBUFFERS = layout.offsetof(14);
        MAXVERTEXBUFFERS = layout.offsetof(15);
        MAXDYNAMICINDEXBUFFERS = layout.offsetof(16);
        MAXDYNAMICVERTEXBUFFERS = layout.offsetof(17);
        MAXUNIFORMS = layout.offsetof(18);
        MAXOCCLUSIONQUERIES = layout.offsetof(19);
        MAXENCODERS = layout.offsetof(20);
        MINRESOURCECBSIZE = layout.offsetof(21);
        TRANSIENTVBSIZE = layout.offsetof(22);
        TRANSIENTIBSIZE = layout.offsetof(23);
    }

    public static class Buffer
    extends StructBuffer<BGFXCapsLimits, Buffer> {
        private static final BGFXCapsLimits ELEMENT_FACTORY = BGFXCapsLimits.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXCapsLimits getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int maxDrawCalls() {
            return BGFXCapsLimits.nmaxDrawCalls(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxBlits() {
            return BGFXCapsLimits.nmaxBlits(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTextureSize() {
            return BGFXCapsLimits.nmaxTextureSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTextureLayers() {
            return BGFXCapsLimits.nmaxTextureLayers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxViews() {
            return BGFXCapsLimits.nmaxViews(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFrameBuffers() {
            return BGFXCapsLimits.nmaxFrameBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFBAttachments() {
            return BGFXCapsLimits.nmaxFBAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPrograms() {
            return BGFXCapsLimits.nmaxPrograms(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxShaders() {
            return BGFXCapsLimits.nmaxShaders(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTextures() {
            return BGFXCapsLimits.nmaxTextures(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxTextureSamplers() {
            return BGFXCapsLimits.nmaxTextureSamplers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxComputeBindings() {
            return BGFXCapsLimits.nmaxComputeBindings(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexLayouts() {
            return BGFXCapsLimits.nmaxVertexLayouts(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexStreams() {
            return BGFXCapsLimits.nmaxVertexStreams(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxIndexBuffers() {
            return BGFXCapsLimits.nmaxIndexBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxVertexBuffers() {
            return BGFXCapsLimits.nmaxVertexBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDynamicIndexBuffers() {
            return BGFXCapsLimits.nmaxDynamicIndexBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDynamicVertexBuffers() {
            return BGFXCapsLimits.nmaxDynamicVertexBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxUniforms() {
            return BGFXCapsLimits.nmaxUniforms(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxOcclusionQueries() {
            return BGFXCapsLimits.nmaxOcclusionQueries(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxEncoders() {
            return BGFXCapsLimits.nmaxEncoders(this.address());
        }

        @NativeType(value="uint32_t")
        public int minResourceCbSize() {
            return BGFXCapsLimits.nminResourceCbSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int transientVbSize() {
            return BGFXCapsLimits.ntransientVbSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int transientIbSize() {
            return BGFXCapsLimits.ntransientIbSize(this.address());
        }
    }
}

