/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.CssPreprocessor;
import org.openide.util.Parameters;

public interface CssPreprocessorsListener
extends EventListener {
    public void preprocessorsChanged();

    public void optionsChanged(@NonNull CssPreprocessor var1);

    public void customizerChanged(@NonNull Project var1, @NonNull CssPreprocessor var2);

    public void processingErrorOccured(@NonNull Project var1, @NonNull CssPreprocessor var2, @NonNull String var3);

    public static final class Support {
        private final List<CssPreprocessorsListener> listeners = new CopyOnWriteArrayList<CssPreprocessorsListener>();

        public void addCssPreprocessorListener(@NullAllowed CssPreprocessorsListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeCssPreprocessorListener(@NullAllowed CssPreprocessorsListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public void firePreprocessorsChanged() {
            for (CssPreprocessorsListener listener : this.listeners) {
                listener.preprocessorsChanged();
            }
        }

        public void fireOptionsChanged(@NonNull CssPreprocessor cssPreprocessor) {
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            for (CssPreprocessorsListener listener : this.listeners) {
                listener.optionsChanged(cssPreprocessor);
            }
        }

        public void fireCustomizerChanged(@NonNull Project project, @NonNull CssPreprocessor cssPreprocessor) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            for (CssPreprocessorsListener listener : this.listeners) {
                listener.customizerChanged(project, cssPreprocessor);
            }
        }

        public void fireProcessingErrorOccured(@NonNull Project project, @NonNull CssPreprocessor cssPreprocessor, @NonNull String error) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            Parameters.notNull((CharSequence)"error", (Object)error);
            for (CssPreprocessorsListener listener : this.listeners) {
                listener.processingErrorOccured(project, cssPreprocessor, error);
            }
        }

        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }
    }
}

