/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config.xml.ds;

import org.netbeans.modules.javaee.wildfly.config.xml.AbstractHierarchicalHandler;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflyDataSource;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflySecurityHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WildflyDatasourceHandler
extends AbstractHierarchicalHandler {
    private StringBuilder buffer;
    private WildflyDataSource currentDatasource;
    private WildflySecurityHandler childHandler;

    public WildflyDatasourceHandler(DefaultHandler parent, XMLReader parser) {
        super(parent, parser);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("datasource".equals(qName)) {
            this.currentDatasource = new WildflyDataSource();
            this.currentDatasource.setJndiName(attributes.getValue(uri, "jndi-name"));
            this.currentDatasource.setName(attributes.getValue(uri, "pool-name"));
        } else if ("driver".equals(qName)) {
            this.buffer = new StringBuilder();
        } else if ("connection-url".equals(qName)) {
            this.buffer = new StringBuilder();
        } else if ("security".equals(qName)) {
            this.childHandler = new WildflySecurityHandler(this, this.parser);
            this.childHandler.start(uri, localName, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("driver".equals(qName)) {
            this.currentDatasource.setDriver(this.buffer.toString());
        } else if ("connection-url".equals(qName)) {
            this.currentDatasource.setUrl(this.buffer.toString());
        } else if ("security".equals(qName)) {
            this.currentDatasource.setUsername(this.childHandler.getUsername());
            this.currentDatasource.setPassword(this.childHandler.getPassword());
        } else if ("datasource".equals(qName)) {
            this.end(uri, localName, qName);
        }
    }

    public WildflyDataSource getDatasource() {
        return this.currentDatasource;
    }
}

