/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.javaee.wildfly.nodes.SimplePropertySupport;
import org.netbeans.modules.javaee.wildfly.nodes.actions.ResourceType;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleCookieImpl;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WildflyDatasourceNode
extends AbstractNode {
    public WildflyDatasourceNode(String name, Datasource ds, Lookup lookup) {
        super(Children.LEAF);
        this.getCookieSet().add((Node.Cookie)new UndeployModuleCookieImpl(name, ResourceType.DATASOURCE, lookup));
        this.setDisplayName(ds.getJndiName());
        this.setName(name);
        this.setShortDescription(ds.getDisplayName());
        this.initProperties(ds);
    }

    protected void initProperties(Datasource ds) {
        this.addProperty("Driver", ds.getDriverClassName());
        this.addProperty("JndiName", ds.getJndiName());
        this.addProperty("Url", ds.getUrl());
        this.addProperty("Username", ds.getUsername());
        this.addProperty("Password", ds.getPassword());
    }

    private void addProperty(String name, String value) {
        String displayName = NbBundle.getMessage(WildflyDatasourceNode.class, (String)("LBL_Resources_Datasources_Datasource_" + name));
        String description = NbBundle.getMessage(WildflyDatasourceNode.class, (String)("DESC_Resources_Datasources_Datasource_" + name));
        SimplePropertySupport ps = new SimplePropertySupport(name, value, displayName, description);
        this.getSheet().get("properties").put((Node.Property)ps);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        this.setSheet(sheet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(PropertiesAction.class), SystemAction.get(UndeployModuleAction.class)};
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/jdbc.gif");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/jdbc.gif");
    }
}

