/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class FileStatusCache {
    public static final String PROP_FILE_STATUS_CHANGED = "status.changed";
    public static final FileStatus REPOSITORY_STATUS_UNKNOWN = null;
    public static final boolean FULL_REPO_SCAN_ENABLED = "true".equals(System.getProperty("versioning.mercurial.fullRepoScanEnabled", "false"));
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_UPTODATE = new FileInformation(8, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final FileInformation FILE_INFORMATION_NEWLOCALLY = new FileInformation(4, false);
    public static final FileInformation FILE_INFORMATION_CONFLICT = new FileInformation(64, false);
    public static final FileInformation FILE_INFORMATION_REMOVEDLOCALLY = new FileInformation(256, false);
    private int MAX_COUNT_UPTODATE_FILES = 1024;
    private static final int CACHE_SIZE_WARNING_THRESHOLD = 50000;
    private boolean hugeCacheWarningLogged;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial.fileStatusCacheNewGeneration");
    private static final Logger LOG_UPTODATE_FILES = Logger.getLogger("mercurial.cache.upToDateFiles");
    private PropertyChangeSupport listenerSupport = new PropertyChangeSupport(this);
    private Mercurial hg;
    private final Map<File, FileInformation> cachedFiles;
    private final LinkedHashSet<File> upToDateFiles = new LinkedHashSet(this.MAX_COUNT_UPTODATE_FILES);
    private final RequestProcessor rp = new RequestProcessor("Mercurial.cacheNG", 1, true);
    private final HashSet<File> nestedRepositories = new HashSet(2);
    int upToDateAccess = 0;
    private static final int UTD_NOTIFY_NUMBER = 100;

    FileStatusCache(Mercurial hg) {
        this.hg = hg;
        this.cachedFiles = new HashMap<File, FileInformation>();
    }

    private void handleIgnoredFiles(final Set<File> files) {
        Runnable outOfAWT = new Runnable(){

            @Override
            public void run() {
                for (File f : files) {
                    if (!HgUtils.isIgnored(f, true)) continue;
                    boolean isDirectory = f.isDirectory();
                    boolean exists = f.exists();
                    if (!exists) {
                        FileStatusCache.this.refreshFileStatus(f, FILE_INFORMATION_UNKNOWN);
                        continue;
                    }
                    FileStatusCache.this.refreshFileStatus(f, isDirectory ? new FileInformation(2, true) : FILE_INFORMATION_EXCLUDED);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            this.rp.post(outOfAWT);
        } else {
            outOfAWT.run();
        }
    }

    private FileInformation checkForIgnoredFile(File file) {
        FileInformation fi = null;
        if (HgUtils.isIgnored(file, false)) {
            fi = FILE_INFORMATION_EXCLUDED;
        } else {
            this.handleIgnoredFiles(Collections.singleton(file));
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getInfo(File file) {
        FileInformation info = null;
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            info = this.cachedFiles.get(file);
            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
            synchronized (linkedHashSet) {
                if (info == null && this.upToDateFiles.contains(file)) {
                    this.addUpToDate(file);
                    info = FILE_INFORMATION_UPTODATE;
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInfo(File file, FileInformation info) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.put(file, info);
            if (!this.hugeCacheWarningLogged && this.cachedFiles.size() > 50000) {
                LOG.log(Level.WARNING, "Cache contains too many entries: {0}", this.cachedFiles.size());
                this.hugeCacheWarningLogged = true;
            }
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInfo(File file) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.remove(file);
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            this.upToDateFiles.remove(file);
            this.upToDateFiles.add(file);
            if (this.upToDateFiles.size() >= this.MAX_COUNT_UPTODATE_FILES) {
                if (LOG_UPTODATE_FILES.isLoggable(Level.FINE)) {
                    LOG_UPTODATE_FILES.log(Level.WARNING, "Cache of uptodate files grows too quickly: {0}", this.upToDateFiles.size());
                    this.MAX_COUNT_UPTODATE_FILES <<= 1;
                    assert (false);
                } else {
                    Iterator it = this.upToDateFiles.iterator();
                    int toDelete = this.MAX_COUNT_UPTODATE_FILES >> 3;
                    for (int i = 0; i < toDelete && it.hasNext(); ++i) {
                        it.next();
                        it.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            return this.upToDateFiles.remove(file);
        }
    }

    public FileInformation getStatus(File file) {
        FileInformation fi = this.getInfo(file);
        if (fi == null) {
            boolean isDirectory;
            boolean isAdministrative = HgUtils.isAdministrative(file);
            boolean bl = isDirectory = isAdministrative || file.isDirectory();
            if (isDirectory && (isAdministrative || HgUtils.isIgnored(file))) {
                return new FileInformation(2, true);
            }
            fi = !isDirectory && !this.exists(file) ? FILE_INFORMATION_UNKNOWN : (!isDirectory && HgUtils.isIgnored(file) ? FILE_INFORMATION_EXCLUDED : (isDirectory ? this.refresh(file) : FILE_INFORMATION_UPTODATE));
        }
        return fi;
    }

    public FileInformation getCachedStatus(File file) {
        return this.getCachedStatus(file, false);
    }

    FileInformation markAsSeenInUI(File file) {
        return this.getCachedStatus(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getCachedStatus(final File file, boolean seenInUI) {
        FileInformation info = this.getInfo(file);
        LOG.log(Level.FINER, "getCachedStatus for file {0}: {1}", new Object[]{file, info});
        boolean triggerHgScan = false;
        if (info == null) {
            if (this.hg.isManaged(file)) {
                triggerHgScan = seenInUI;
                info = this.checkForIgnoredFile(file);
                if (file.isDirectory()) {
                    info = this.createFolderFileInformation(file, info == null ? null : new FileInformation(2, true));
                } else if (info == null) {
                    info = FILE_INFORMATION_UPTODATE;
                    this.addUpToDate(file);
                    if (++this.upToDateAccess > 100) {
                        this.upToDateAccess = 0;
                        if (LOG_UPTODATE_FILES.isLoggable(Level.FINE)) {
                            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
                            synchronized (linkedHashSet) {
                                LOG_UPTODATE_FILES.log(Level.FINE, "Another {0} U2D files added: {1}", new Object[]{100, this.upToDateFiles});
                            }
                        }
                    }
                } else {
                    this.rp.post(new Runnable(){

                        @Override
                        public void run() {
                            FileStatusCache.this.refreshFileStatus(file, FILE_INFORMATION_EXCLUDED);
                        }
                    });
                }
            } else {
                info = file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            LOG.log(Level.FINER, "getCachedStatus: default for file {0}: {1}", new Object[]{file, info});
        } else {
            boolean bl = triggerHgScan = seenInUI && !info.wasSeenInUi();
        }
        if (triggerHgScan) {
            info.setSeenInUI(true);
            this.hg.getMercurialInterceptor().pingRepositoryRootFor(file);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation createFolderFileInformation(File folder, FileInformation fi) {
        FileInformation info;
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            info = this.getInfo(folder);
            if (info == null || !info.isDirectory()) {
                info = fi == null ? new FileInformation(8, true) : fi;
                this.setInfo(folder, info);
            }
        }
        return info;
    }

    private Map<File, FileInformation> getModifiedFiles(File root, int includeStatus) {
        boolean check = false;
        if (!$assertionsDisabled) {
            check = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        HashMap<File, FileInformation> modifiedFiles = new HashMap<File, FileInformation>();
        FileInformation info = this.getCachedStatus(root);
        if ((info.getStatus() & includeStatus) != 0) {
            modifiedFiles.put(root, info);
        }
        for (File child : info.getModifiedChildren(false)) {
            if (check) {
                this.checkIsParentOf(root, child);
            }
            modifiedFiles.putAll(this.getModifiedFiles(child, includeStatus));
        }
        return modifiedFiles;
    }

    public void refreshAllRoots(Map<File, Set<File>> rootFiles) {
        for (Map.Entry<File, Set<File>> refreshEntry : rootFiles.entrySet()) {
            File repository = refreshEntry.getKey();
            if (repository == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "refreshAllRoots() roots: {0}, repositoryRoot: {1} ", new Object[]{refreshEntry.getValue(), repository.getAbsolutePath()});
            }
            try {
                Map<File, FileInformation> interestingFiles = HgCommand.getStatus(repository, new LinkedList<File>((Collection)refreshEntry.getValue()), null, null);
                for (Map.Entry<File, FileInformation> interestingEntry : interestingFiles.entrySet()) {
                    File file = interestingEntry.getKey();
                    FileInformation fi = interestingEntry.getValue();
                    LOG.log(Level.FINE, "refreshAllRoots() file: {0} {1} ", new Object[]{file.getAbsolutePath(), fi});
                    this.refreshFileStatus(file, fi);
                }
                for (File root : refreshEntry.getValue()) {
                    for (Map.Entry<File, FileInformation> entry : this.getModifiedFiles(root, -9).entrySet()) {
                        File file = entry.getKey();
                        FileInformation fi = entry.getValue();
                        boolean exists = file.exists();
                        File filesOwner = null;
                        boolean correctRepository = true;
                        if (!interestingFiles.containsKey(file) && ((fi.getStatus() & 2) != 0 && !exists || (fi.getStatus() & 2) == 0 && (!exists || file.isFile())) && (correctRepository = repository.equals(filesOwner = this.hg.getRepositoryRoot(file)))) {
                            LOG.log(Level.FINE, "refreshAllRoots() uninteresting file: {0} {1}", new Object[]{file, fi});
                            if (HgCommand.existsConflictFile(file.getAbsolutePath())) {
                                this.refreshFileStatus(file, FILE_INFORMATION_CONFLICT);
                            } else {
                                this.refreshFileStatus(file, FILE_INFORMATION_UNKNOWN);
                            }
                        }
                        if (correctRepository || !this.nestedRepositories.add(filesOwner)) continue;
                        LOG.log(Level.INFO, "refreshAllRoots: nested repository found: {0} contains {1}", new File[]{repository, filesOwner});
                    }
                }
            }
            catch (HgException ex) {
                LOG.log(Level.INFO, "refreshAll() file: {0} {1} {2} ", new Object[]{repository.getAbsolutePath(), refreshEntry.getValue(), ex.toString()});
            }
        }
    }

    public void refreshAllRoots(Collection<File> files) {
        long startTime = 0L;
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
            Mercurial.STATUS_LOG.fine("refreshAll: starting for " + files.size() + " files.");
        }
        if (files.isEmpty()) {
            return;
        }
        HashMap<File, Set<File>> rootFiles = new HashMap<File, Set<File>>(5);
        for (File file : files) {
            file = FileUtil.normalizeFile((File)file);
            File repository = Mercurial.getInstance().getRepositoryRoot(file);
            if (repository == null) continue;
            Set<File> filesUnderRoot = rootFiles.get(repository);
            if (filesUnderRoot == null) {
                filesUnderRoot = new HashSet<File>();
                rootFiles.put(repository, filesUnderRoot);
            }
            HgUtils.prepareRootFiles(repository, filesUnderRoot, file);
        }
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
            Mercurial.STATUS_LOG.fine("refreshAll: starting status scan for " + rootFiles.values() + " after " + (System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
        }
        if (!rootFiles.isEmpty()) {
            this.refreshAllRoots(rootFiles);
        }
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINE)) {
            Mercurial.STATUS_LOG.fine("refreshAll: finishes status scan after " + (System.currentTimeMillis() - startTime));
        }
    }

    public FileInformation refresh(File root) {
        FileInformation fi;
        File repositoryRoot = this.hg.getRepositoryRoot(root);
        if (repositoryRoot == null) {
            fi = root.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
        } else {
            this.refreshAllRoots(Collections.singletonMap(repositoryRoot, Collections.singleton(root)));
            fi = this.getCachedStatus(root);
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFileStatus(File file, FileInformation fi) {
        FileInformation current;
        if (file == null || fi == null) {
            return;
        }
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            if (FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fi) && (HgUtils.isIgnored(file) || (this.getCachedStatus(file.getParentFile()).getStatus() & 2) != 0)) {
                LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is NotSharable", file.getAbsolutePath());
                FileInformation fileInformation = fi = file.isDirectory() ? new FileInformation(2, true) : FILE_INFORMATION_EXCLUDED;
            }
            if (FileStatusCache.equivalent(fi, current = this.getInfo(file = FileUtil.normalizeFile((File)file)))) {
                return;
            }
            if (fi.getStatus() == 0) {
                this.removeInfo(file);
            } else if (fi.getStatus() == 8 && file.isFile()) {
                this.removeInfo(file);
                this.addUpToDate(file);
            } else {
                this.setInfo(file, fi);
            }
            this.updateParentInformation(file, current, fi);
        }
        this.fireFileStatusChanged(file, current, fi);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerSupport.removePropertyChangeListener(listener);
    }

    private void updateParentInformation(File file, FileInformation oldInfo, FileInformation newInfo) {
        FileInformation info;
        boolean check = false;
        if (!$assertionsDisabled) {
            check = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        File parent = file;
        FileInformation childInfo = newInfo;
        File child = file;
        while ((parent = parent.getParentFile()) != null && (info = this.getCachedStatus(parent, false)) != null && (info.getStatus() & 0xFFFFFFFE) != 0) {
            if (!info.isDirectory()) {
                info = this.createFolderFileInformation(parent, null);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "updateParentInformation: updating {0} with {1} triggered by {2}", new Object[]{parent, newInfo, file});
            }
            if (check) {
                this.checkIsParentOf(parent, child);
                if (info == FILE_INFORMATION_EXCLUDED || info == FILE_INFORMATION_UPTODATE || info == FILE_INFORMATION_NOTMANAGED || info == FILE_INFORMATION_NOTMANAGED_DIRECTORY || info == FILE_INFORMATION_UNKNOWN || info == FILE_INFORMATION_NEWLOCALLY) {
                    throw new IllegalStateException("Wrong info, expected an own instance for " + parent + ", " + info.getStatusText() + " - " + info.getStatus());
                }
            }
            if (!info.setModifiedChild(child, childInfo)) break;
            if (!info.getModifiedChildren(true).isEmpty() && (newInfo.getStatus() & 0x40) == 0) {
                childInfo = new FileInformation(64, true);
            }
            child = parent;
        }
    }

    private void fireFileStatusChanged(File file, FileInformation oldInfo, FileInformation newInfo) {
        this.listenerSupport.firePropertyChange(PROP_FILE_STATUS_CHANGED, null, new ChangedEvent(file, oldInfo, newInfo));
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        FileStatus e2;
        if (other == null || main.getStatus() != other.getStatus() || main.isDirectory() != other.isDirectory()) {
            return false;
        }
        FileStatus e1 = main.getStatus(null);
        return e1 == (e2 = other.getStatus(null)) || e1 == null || e2 == null || FileStatusCache.equal(e1, e2);
    }

    private static boolean equal(FileStatus e1, FileStatus e2) {
        return true;
    }

    public File[] listFiles(File dir) {
        HashSet<File> set = this.getStatus(dir).getModifiedChildren(false);
        return set.toArray(new File[0]);
    }

    public boolean containsFileOfStatus(VCSContext context, int includeStatus, boolean checkCommitExclusions) {
        return this.containsFileOfStatus(context.getRootFiles(), includeStatus, checkCommitExclusions);
    }

    public boolean containsFileOfStatus(Collection<File> roots, int includeStatus, boolean checkCommitExclusions) {
        for (File root : roots) {
            if (!this.hasStatus(root, includeStatus, checkCommitExclusions) && !this.containsFileOfStatus(root, includeStatus, checkCommitExclusions, !VersioningSupport.isFlat((File)root))) continue;
            return true;
        }
        return false;
    }

    private boolean containsFileOfStatus(File root, int includeStatus, boolean checkExclusions, boolean recursive) {
        boolean check = false;
        if (!$assertionsDisabled) {
            check = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        FileInformation info = this.getCachedStatus(root);
        for (File child : info.getModifiedChildren(includeStatus == 64)) {
            if (check) {
                this.checkIsParentOf(root, child);
            }
            if (this.hasStatus(child, includeStatus, checkExclusions)) {
                return true;
            }
            if (!recursive || !this.containsFileOfStatus(child, includeStatus, checkExclusions, recursive)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStatus(File file, int includeStatus, boolean checkExclusions) {
        FileInformation info = this.getCachedStatus(file);
        return (info.getStatus() & includeStatus) != 0 && (!checkExclusions || !HgModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath()));
    }

    public File[] listFiles(VCSContext context, int includeStatus) {
        Set roots = context.getRootFiles();
        Set<File> set = this.listFilesIntern(roots.toArray(new File[0]), includeStatus);
        for (File excluded : context.getExclusions()) {
            Iterator<File> j = set.iterator();
            while (j.hasNext()) {
                File file = j.next();
                if (!Utils.isAncestorOrEqual((File)excluded, (File)file)) continue;
                j.remove();
            }
        }
        return set.toArray(new File[0]);
    }

    public File[] listFiles(File[] roots, int includeStatus) {
        Set<File> listedFiles = this.listFilesIntern(roots, includeStatus);
        return listedFiles.toArray(new File[0]);
    }

    private Set<File> listFilesIntern(File[] roots, int includeStatus) {
        HashSet<File> listedFiles = new HashSet<File>();
        for (File root : roots) {
            if (VersioningSupport.isFlat((File)root)) {
                for (File listed : this.listFiles(root)) {
                    if ((this.getCachedStatus(listed).getStatus() & includeStatus) == 0) continue;
                    listedFiles.add(listed);
                }
                continue;
            }
            Map<File, FileInformation> modified = this.getModifiedFiles(root, includeStatus);
            for (File listed : modified.keySet()) {
                listedFiles.add(listed);
            }
        }
        return listedFiles;
    }

    public void notifyFileChanged(File file) {
        this.fireFileStatusChanged(file, null, FILE_INFORMATION_UPTODATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIgnores(File file) {
        Map<File, FileInformation> files = this.getModifiedFiles(file, -1);
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            for (File f : files.keySet()) {
                this.refreshFileStatus(f, FILE_INFORMATION_UNKNOWN);
            }
        }
        this.refresh(file);
        LOG.log(Level.FINER, "refreshIgnores: File {0} refreshed", file);
    }

    private void checkIsParentOf(File parent, File child) {
        if (!parent.equals(child.getParentFile())) {
            throw new IllegalStateException(parent.getAbsolutePath() + " is not parent of " + child.getAbsolutePath());
        }
    }

    public static class ChangedEvent {
        private File file;
        private FileInformation oldInfo;
        private FileInformation newInfo;

        public ChangedEvent(File file, FileInformation oldInfo, FileInformation newInfo) {
            this.file = file;
            this.oldInfo = oldInfo;
            this.newInfo = newInfo;
        }

        public File getFile() {
            return this.file;
        }

        public FileInformation getOldInfo() {
            return this.oldInfo;
        }

        public FileInformation getNewInfo() {
            return this.newInfo;
        }
    }
}

