/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

class MultiBundleStructure
extends BundleStructure
implements Serializable {
    private transient FileObject[] files;
    private transient FileObject parent;
    private transient PropertiesFileEntry primaryEntry;
    private String baseName;
    private String extension;
    static final long serialVersionUID = 7501232754255253334L;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();

    protected MultiBundleStructure() {
    }

    public MultiBundleStructure(PropertiesDataObject obj) {
        this.obj = obj;
        this.baseName = Util.getBaseName(obj.getName());
        this.extension = "properties";
    }

    private synchronized void findEntries() {
        if (this.obj != null) {
            if (!this.obj.isValid()) {
                this.primaryEntry = null;
                if (this.files != null && this.files.length == 1) {
                    this.obj = null;
                    this.files = null;
                    return;
                }
            } else {
                this.primaryEntry = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            }
        } else {
            return;
        }
        if (this.primaryEntry != null) {
            FileObject primary = this.primaryEntry.getFile();
            if (!primary.hasExt(this.extension) && primary.getMIMEType().equalsIgnoreCase("text/x-properties")) {
                this.extension = primary.getExt();
            }
            this.parent = primary.getParent();
        } else if (this.parent == null) {
            return;
        }
        ArrayList<FileObject> listFileObjects = new ArrayList<FileObject>();
        for (FileObject file : this.parent.getChildren()) {
            int index;
            if (!file.hasExt(this.extension) || !file.getMIMEType().equalsIgnoreCase("text/x-properties")) continue;
            String fName = file.getName();
            if (fName.equals(this.baseName) && file.isValid()) {
                listFileObjects.add(0, file);
            }
            if (fName.indexOf(this.baseName) == -1 || (index = fName.indexOf(95, this.baseName.length() - 1)) != this.baseName.length() || file == null || !MultiBundleStructure.isValidLocaleSuffix(fName.substring(index)) || !file.isValid()) continue;
            listFileObjects.add(file);
        }
        if (listFileObjects.isEmpty()) {
            this.files = new FileObject[]{this.obj.getPrimaryFile()};
            return;
        }
        this.files = listFileObjects.toArray(new FileObject[0]);
        if (this.primaryEntry != this.getNthEntry(0)) {
            this.primaryEntry = this.getNthEntry(0);
            if (this.primaryEntry != null) {
                this.notifyOneFileChanged(this.primaryEntry.getFile());
                if (!this.primaryEntry.getFile().hasExt(this.extension) && this.primaryEntry.getFile().getMIMEType().equalsIgnoreCase("text/x-properties")) {
                    this.extension = this.primaryEntry.getFile().getExt();
                }
                this.parent = this.primaryEntry.getFile().getParent();
                this.obj = (PropertiesDataObject)this.primaryEntry.getDataObject();
                this.baseName = Util.getBaseName(this.obj.getName());
            }
        }
    }

    @Override
    void updateEntries() {
        this.findEntries();
        if (this.files != null) {
            this.buildKeySet();
        }
    }

    void moveEntry(int fromIndex, int toIndex) {
        if (fromIndex >= 0 && fromIndex < this.getEntryCount() && toIndex >= 0 && toIndex < this.getEntryCount()) {
            int i;
            int sortIndex = this.getSortIndex();
            if (fromIndex + 1 == sortIndex) {
                sortIndex = toIndex + 1;
            }
            FileObject tmpFO = null;
            if (fromIndex < toIndex) {
                tmpFO = this.files[fromIndex];
                for (i = fromIndex; i < toIndex; ++i) {
                    this.files[i] = this.files[i + 1];
                    if (i != sortIndex - 1) continue;
                    --sortIndex;
                }
                this.files[toIndex] = tmpFO;
            } else if (fromIndex > toIndex) {
                tmpFO = this.files[fromIndex];
                for (i = fromIndex; i > toIndex; --i) {
                    this.files[i] = this.files[i - 1];
                    if (i != sortIndex - 1) continue;
                    ++sortIndex;
                }
                this.files[toIndex] = tmpFO;
            }
            if (this.getSortIndex() == toIndex + 1) {
                sortIndex = fromIndex + 1;
            }
            if (sortIndex != this.getSortIndex()) {
                boolean ascending = this.getSortOrder();
                this.sort(sortIndex);
                if (!ascending) {
                    this.sort(sortIndex);
                }
            }
        }
    }

    @Override
    public PropertiesFileEntry getNthEntry(int index) {
        if (this.files == null) {
            return null;
        }
        if (index >= 0 && index < this.files.length) {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.files[index]);
                if (dataObject instanceof PropertiesDataObject) {
                    return (PropertiesFileEntry)((PropertiesDataObject)dataObject).getPrimaryEntry();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int getEntryIndexByFileName(String fileName) {
        if (this.files == null) {
            return -1;
        }
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.files[i].getName().equals(fileName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public PropertiesFileEntry getEntryByFileName(String fileName) {
        int index = this.getEntryIndexByFileName(fileName);
        try {
            return index == -1 ? null : (PropertiesFileEntry)((PropertiesDataObject)DataObject.find((FileObject)this.files[index])).getPrimaryEntry();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public int getEntryCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    private void notifyEntriesNotInitialized() {
        throw new IllegalStateException("Resource Bundles: Entries not initialized");
    }

    private static boolean isValidLocaleSuffix(String s) {
        HashSet<String> knownCountries;
        String s2;
        int n = s.length();
        if (n != 3 && (n <= 3 || s.charAt(3) != '_')) {
            return false;
        }
        String s1 = s.substring(1, 3).toLowerCase();
        if (n == 3) {
            s2 = null;
        } else if (n == 6 || n > 6 && s.charAt(6) == '_') {
            s2 = s.substring(4, 6).toUpperCase();
        } else {
            return false;
        }
        HashSet<String> knownLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        if (!knownLanguages.contains(s1)) {
            return false;
        }
        return s2 == null || (knownCountries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()))).contains(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertiesOpen getOpenSupport() {
        Object object = this.OPEN_SUPPORT_LOCK;
        synchronized (object) {
            if (this.openSupport == null) {
                this.openSupport = new PropertiesOpen(this);
            }
            return this.openSupport;
        }
    }

    @Override
    public int getKeyCount() {
        try {
            return super.getKeyCount();
        }
        catch (IllegalStateException ie) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PropertiesFileEntry[] getEntries() {
        MultiBundleStructure multiBundleStructure = this;
        synchronized (multiBundleStructure) {
            if (this.files == null) {
                return new PropertiesFileEntry[0];
            }
            ArrayList<PropertiesFileEntry> entries = new ArrayList<PropertiesFileEntry>(this.files.length);
            try {
                for (FileObject fileObject : this.files) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (!(dataObject instanceof PropertiesDataObject)) continue;
                    entries.add((PropertiesFileEntry)((PropertiesDataObject)dataObject).getPrimaryEntry());
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            if (entries.isEmpty()) {
                return new PropertiesFileEntry[0];
            }
            return entries.toArray(new PropertiesFileEntry[0]);
        }
    }
}

