/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.openide.awt.GraphicsUtils;

public final class ResultBar
extends JComponent
implements ActionListener {
    private static final Color NOT_COVERED_COLOR = new Color(180, 50, 50);
    private static final Color COVERED_COLOR = new Color(30, 180, 30);
    private static final Color NO_TESTS_COLOR = new Color(110, 110, 110);
    private static final Color ABORTED_TESTS_COLOR = new Color(214, 157, 41);
    private static final Color TEXT_COLOR = new Color(255, 255, 255);
    private static final Color ANIMATION_COLOR = new Color(190, 190, 190);
    private float passedPercentage = 0.0f;
    private float skippedPercentage = 0.0f;
    private float abortedPercentage = 0.0f;
    private final Timer timer = new Timer(100, this);
    private final long startTime;
    private boolean passedReported = false;
    private boolean skippedReported = false;
    private boolean abortedReported = false;

    public ResultBar() {
        this.updateUI();
        this.timer.start();
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.timer.stop();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }

    public float getPassedPercentage() {
        return this.passedPercentage;
    }

    public void setPassedPercentage(float passedPercentage) {
        this.passedPercentage = Float.isNaN(passedPercentage) ? 0.0f : passedPercentage;
        this.passedReported = true;
        this.repaint();
    }

    public void setSkippedPercentage(float skippedPercentage) {
        this.skippedPercentage = Float.isNaN(skippedPercentage) ? 0.0f : skippedPercentage;
        this.skippedReported = true;
        this.repaint();
    }

    public void setAbortedPercentage(float abortedPercentage) {
        this.abortedPercentage = Float.isNaN(abortedPercentage) ? 0.0f : abortedPercentage;
        this.abortedReported = true;
        this.repaint();
    }

    private String getString() {
        return "Tests passed: ".concat(String.format("%.2f %%", Float.valueOf(this.passedPercentage)));
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void updateUI() {
        Font f = new JLabel().getFont();
        f = new Font(f.getName(), 1, f.getSize());
        this.setFont(f);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color fillColor = NO_TESTS_COLOR;
        if (this.abortedReported || this.skippedReported || this.passedReported) {
            if ((double)this.passedPercentage == 100.0) {
                fillColor = COVERED_COLOR;
            } else if ((double)this.abortedPercentage > 0.0) {
                fillColor = ABORTED_TESTS_COLOR;
            } else if ((double)(100.0f - this.passedPercentage - this.abortedPercentage - this.skippedPercentage) > 1.0E-4) {
                fillColor = NOT_COVERED_COLOR;
            } else if ((double)this.skippedPercentage > 0.0) {
                fillColor = NO_TESTS_COLOR;
            }
        }
        g2.setPaint(fillColor);
        g2.fillRect(0, 0, width - 1, height - 1);
        if (this.timer.isRunning()) {
            g2.setPaint(ANIMATION_COLOR);
            float step = (float)(System.currentTimeMillis() - this.startTime) / 150.0f;
            g2.setStroke(new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{10.0f}, step));
            g2.drawRect(2, 2, width - 6, height - 6);
        }
        this.paintText(g2, width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        int stringHeight;
        Insets border = this.getInsets();
        FontMetrics fontSizer = this.getFontMetrics(this.getFont());
        Container parent = this.getParent();
        Insets insets = parent.getInsets();
        Dimension size = new Dimension(parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
        String string = this.getString();
        int stringWidth = fontSizer.stringWidth(string);
        if (stringWidth > size.width) {
            size.width = stringWidth;
        }
        if ((stringHeight = fontSizer.getHeight() + fontSizer.getDescent()) > size.height) {
            size.height = stringHeight;
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = 40;
        return pref;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = Short.MAX_VALUE;
        return pref;
    }

    @Override
    public int getBaseline(int w, int h) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return h - fm.getDescent() - (h - fm.getHeight()) / 2;
    }

    private void paintText(Graphics2D g, int w, int h) {
        Font font = this.getFont();
        String text = this.getString();
        GlyphVector gv = font.createGlyphVector(g.getFontRenderContext(), text);
        FontMetrics fm = g.getFontMetrics(font);
        Shape outline = gv.getOutline();
        Rectangle2D bounds = outline.getBounds2D();
        double x = Math.max(0.0, ((double)w - bounds.getWidth()) / 2.0);
        double y = (double)h / 2.0 + (double)fm.getAscent() / 2.0 - 2.0;
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        g.setColor(TEXT_COLOR);
        g.fill(outline);
        g.setTransform(oldTransform);
    }
}

