/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateSubnetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSubnetRequest
extends BmcRequest<UpdateSubnetDetails> {
    private String subnetId;
    private UpdateSubnetDetails updateSubnetDetails;
    private String ifMatch;

    public String getSubnetId() {
        return this.subnetId;
    }

    public UpdateSubnetDetails getUpdateSubnetDetails() {
        return this.updateSubnetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateSubnetDetails getBody$() {
        return this.updateSubnetDetails;
    }

    public Builder toBuilder() {
        return new Builder().subnetId(this.subnetId).updateSubnetDetails(this.updateSubnetDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subnetId=").append(String.valueOf(this.subnetId));
        sb.append(",updateSubnetDetails=").append(String.valueOf((Object)this.updateSubnetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSubnetRequest)) {
            return false;
        }
        UpdateSubnetRequest other = (UpdateSubnetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals((Object)this.updateSubnetDetails, (Object)other.updateSubnetDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.updateSubnetDetails == null ? 43 : this.updateSubnetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSubnetRequest, UpdateSubnetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subnetId = null;
        private UpdateSubnetDetails updateSubnetDetails = null;
        private String ifMatch = null;

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder updateSubnetDetails(UpdateSubnetDetails updateSubnetDetails) {
            this.updateSubnetDetails = updateSubnetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSubnetRequest o) {
            this.subnetId(o.getSubnetId());
            this.updateSubnetDetails(o.getUpdateSubnetDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSubnetRequest build() {
            UpdateSubnetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSubnetDetails body) {
            this.updateSubnetDetails(body);
            return this;
        }

        public UpdateSubnetRequest buildWithoutInvocationCallback() {
            UpdateSubnetRequest request = new UpdateSubnetRequest();
            request.subnetId = this.subnetId;
            request.updateSubnetDetails = this.updateSubnetDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

