<?php

namespace {

	/**
	 * <p>Classes implementing <b>Countable</b> can be used with the <code>count()</code> function.</p>
	 * @link https://php.net/manual/en/class.countable.php
	 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
	 */
	interface Countable {

		/**
		 * Count elements of an object
		 * <p>This method is executed when the <code>value</code> for <code>count()</code> is an object implementing <code>Countable</code>.</p>
		 * @return int <p>The custom count as an <code>int</code>.</p>
		 * @link https://php.net/manual/en/countable.count.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function count(): int;
	}

}
