/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(16, 24, -23, -25) >> uvec4(16u, 24u, 23u, 25u)) => ivec4(0, 0, -1, -1)
 * (ivec4(16, 24, -23, -25) >> uvec4(23u, 12u, 14u, 19u)) => ivec4(0, 0, -1, -1)
 * (ivec4(16, 24, 23, 25) >> uvec4(16u, 24u, 23u, 25u)) => ivec4(0, 0, 0, 0)
 * (ivec4(16, 24, 23, 25) >> uvec4(23u, 12u, 14u, 19u)) => ivec4(0, 0, 0, 0)
 * (ivec4(-23, -12, 14, 19) >> uvec4(16u, 24u, 23u, 25u)) => ivec4(-1, -1, 0, 0)
 * (ivec4(-23, -12, 14, 19) >> uvec4(23u, 12u, 14u, 19u)) => ivec4(-1, -1, 0, 0)
 * (ivec4(23, 12, 14, 19) >> uvec4(16u, 24u, 23u, 25u)) => ivec4(0, 0, 0, 0)
 * (ivec4(23, 12, 14, 19) >> uvec4(23u, 12u, 14u, 19u)) => ivec4(0, 0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec4(16, 24, -23, -25) >> uvec4(16u, 24u, 23u, 25u)), ivec4(0, 0, -1, -1))) ? 1 : -1] array0;
  float[all(equal((ivec4(16, 24, -23, -25) >> uvec4(23u, 12u, 14u, 19u)), ivec4(0, 0, -1, -1))) ? 1 : -1] array1;
  float[all(equal((ivec4(16, 24, 23, 25) >> uvec4(16u, 24u, 23u, 25u)), ivec4(0, 0, 0, 0))) ? 1 : -1] array2;
  float[all(equal((ivec4(16, 24, 23, 25) >> uvec4(23u, 12u, 14u, 19u)), ivec4(0, 0, 0, 0))) ? 1 : -1] array3;
  float[all(equal((ivec4(-23, -12, 14, 19) >> uvec4(16u, 24u, 23u, 25u)), ivec4(-1, -1, 0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec4(-23, -12, 14, 19) >> uvec4(23u, 12u, 14u, 19u)), ivec4(-1, -1, 0, 0))) ? 1 : -1] array5;
  float[all(equal((ivec4(23, 12, 14, 19) >> uvec4(16u, 24u, 23u, 25u)), ivec4(0, 0, 0, 0))) ? 1 : -1] array6;
  float[all(equal((ivec4(23, 12, 14, 19) >> uvec4(23u, 12u, 14u, 19u)), ivec4(0, 0, 0, 0))) ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
