/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.attach.steps;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.lib.common.AttachSettings;
import org.graalvm.visualvm.lib.common.integration.IntegrationUtils;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.attach.providers.RemotePackExporter;
import org.graalvm.visualvm.lib.profiler.attach.spi.AttachStepsProvider;
import org.graalvm.visualvm.lib.profiler.attach.steps.Bundle;
import org.openide.util.RequestProcessor;

public class BasicAttachStepsProvider
extends AttachStepsProvider {
    protected static final String LINK_CLIPBOARD = "file:/clipboard";
    protected static final String LINK_REMOTEPACK = "file:/remotepack";
    protected static final String LINK_JDK5 = "file:/jdk5";
    protected static final String LINK_JDK6UP = "file:/jdk6up";
    protected static final String LINK_32ARCH = "file:/32arch";
    protected static final String LINK_64ARCH = "file:/64arch";
    protected String currentJDK = "file:/jdk6up";
    protected String currentARCH = "file:/64arch";
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private static final AtomicBoolean exportRunning = new AtomicBoolean(false);

    @Override
    public final synchronized void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final synchronized void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected final synchronized void fireChange(ChangeEvent e) {
        if (e == null) {
            e = new ChangeEvent(this);
        }
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(e);
        }
    }

    @Override
    public String getSteps(AttachSettings settings) {
        if (settings.isRemote()) {
            return this.remoteDirectSteps(settings);
        }
        if (settings.isDirect()) {
            return this.localDirectSteps(settings);
        }
        return this.localDynamicSteps(settings);
    }

    @Override
    public void handleAction(String action, AttachSettings settings) {
        if (LINK_CLIPBOARD.equals(action)) {
            this.copyParameters(settings);
        } else if (LINK_REMOTEPACK.equals(action)) {
            this.createRemotePack(settings);
        } else if (LINK_JDK5.equals(action)) {
            this.switchToJDK5();
        } else if (LINK_JDK6UP.equals(action)) {
            this.switchToJDK6Up();
        } else if (LINK_32ARCH.equals(action)) {
            this.switchTo32ARCH();
        } else if (LINK_64ARCH.equals(action)) {
            this.switchTo64ARCH();
        }
    }

    protected void switchToJDK5() {
        this.currentJDK = LINK_JDK5;
        this.fireChange(null);
    }

    protected void switchToJDK6Up() {
        this.currentJDK = LINK_JDK6UP;
        this.fireChange(null);
    }

    protected void switchTo32ARCH() {
        this.currentARCH = LINK_32ARCH;
        this.fireChange(null);
    }

    protected void switchTo64ARCH() {
        this.currentARCH = LINK_64ARCH;
        this.fireChange(null);
    }

    protected String localDynamicSteps(AttachSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(1));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_MakeSureStarted(System.getProperty("user.name")));
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(2));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_SubmitSelectProcess());
        b.append("</div>");
        return b.toString();
    }

    protected String localDirectSteps(AttachSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(1));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_EnsureCorrectJava(BasicAttachStepsProvider.getCorrectJavaMsg(this.currentJDK, this.currentARCH)));
        String linkStart = " <a href='";
        linkStart = linkStart + (LINK_JDK6UP.equals(this.currentJDK) ? LINK_JDK5 : LINK_JDK6UP);
        linkStart = linkStart + "'>";
        String linkEnd = "</a> ";
        b.append(LINK_JDK6UP.equals(this.currentJDK) ? Bundle.AttachDialog_Steps_SwitchToJava5(linkStart, linkEnd) : Bundle.AttachDialog_Steps_SwitchToJava6Up(linkStart, linkEnd));
        if (!IntegrationUtils.PLATFORM_MAC_OS.equals(IntegrationUtils.getLocalPlatform((int)-1))) {
            linkStart = " <a href='";
            linkStart = linkStart + (LINK_64ARCH.equals(this.currentARCH) ? LINK_32ARCH : LINK_64ARCH);
            linkStart = linkStart + "'>";
            b.append(LINK_64ARCH.equals(this.currentARCH) ? Bundle.AttachDialog_Steps_SwitchTo32BitArch(linkStart, linkEnd) : Bundle.AttachDialog_Steps_SwitchTo64BitArch(linkStart, linkEnd));
        }
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(2));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_AddParameters());
        b.append(" (<a href='");
        b.append(LINK_CLIPBOARD);
        b.append("'>");
        b.append(Bundle.AttachDialog_Steps_CopyToClipboard());
        b.append("</a>):");
        b.append("</div>");
        b.append("<pre>");
        b.append(this.parameters(settings));
        b.append("</pre>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(3));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_StartApplication());
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(4));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_SubmitUnblock());
        b.append("</div>");
        return b.toString();
    }

    protected String remoteDirectSteps(AttachSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(1));
        b.append("</b> ");
        if (BasicAttachStepsProvider.isCVMJVM(settings)) {
            b.append(Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_JavaCvm()));
        } else if (BasicAttachStepsProvider.isARMJVM(settings)) {
            b.append(Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_JavaSeEmbedded()));
        } else {
            b.append(LINK_JDK6UP.equals(this.currentJDK) ? Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_Java6()) : Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_Java5()));
            String linkStart = " <a href='";
            linkStart = linkStart + (LINK_JDK6UP.equals(this.currentJDK) ? LINK_JDK5 : LINK_JDK6UP);
            linkStart = linkStart + "'>";
            String linkEnd = "</a> ";
            b.append(LINK_JDK6UP.equals(this.currentJDK) ? Bundle.AttachDialog_Steps_SwitchToJava5(linkStart, linkEnd) : Bundle.AttachDialog_Steps_SwitchToJava6Up(linkStart, linkEnd));
        }
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(2));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_CreateRemotePack("'file:/remotepack'", "<code>&lt;remote&gt;</code>"));
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(3));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_RunCalibrateScript("<code>" + IntegrationUtils.getRemoteCalibrateCommandString((String)settings.getHostOS(), (String)BasicAttachStepsProvider.getPlatform(settings, this.currentJDK)) + "</code>"));
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(4));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_AddParameters());
        b.append(" (<a href='");
        b.append(LINK_CLIPBOARD);
        b.append("'>");
        b.append(Bundle.AttachDialog_Steps_CopyToClipboard());
        b.append("</a>):");
        b.append("</div>");
        b.append("<pre>");
        b.append(this.parameters(settings));
        b.append("</pre>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(5));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_StartApplication());
        b.append("</div>");
        b.append("<br/>");
        b.append("<div>");
        b.append("<b>");
        b.append(Bundle.AttachDialog_Steps_Step(6));
        b.append("</b> ");
        b.append(Bundle.AttachDialog_Steps_SubmitUnblock());
        b.append("</div>");
        return b.toString();
    }

    protected String parameters(AttachSettings settings) {
        return IntegrationUtils.getProfilerAgentCommandLineArgs((String)BasicAttachStepsProvider.getOS(settings, this.currentARCH), (String)BasicAttachStepsProvider.getPlatform(settings, this.currentJDK), (boolean)settings.isRemote(), (int)settings.getPort());
    }

    protected void copyParameters(AttachSettings settings) {
        String parameters = this.parameters(settings);
        parameters = parameters.replace("&lt;", "<").replace("&gt;", ">");
        StringSelection s = new StringSelection(parameters);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
        ProfilerDialogs.displayInfo((String)Bundle.AttachDialog_CopiedToClipboard());
    }

    protected void createRemotePack(final AttachSettings settings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                chooser.setDialogTitle(Bundle.AttachDialog_RemotePackDialogCaption());
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileSelectionMode(1);
                chooser.setSelectedFile(tmpDir);
                chooser.setCurrentDirectory(tmpDir);
                chooser.setMultiSelectionEnabled(false);
                if ((1 & chooser.showSaveDialog(chooser)) == 0) {
                    final String path = chooser.getSelectedFile().getAbsolutePath();
                    final String jdkF = BasicAttachStepsProvider.this.currentJDK;
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String packPath = BasicAttachStepsProvider.exportRemotePack(path, settings, jdkF);
                                ProfilerDialogs.displayInfo((String)Bundle.AttachDialog_RemotePackSaved(packPath));
                            }
                            catch (IOException ex) {
                                System.err.println("Exception creating remote pack: " + ex);
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String exportRemotePack(String path, AttachSettings settings, String jdk) throws IOException {
        if (exportRunning.compareAndSet(false, true)) {
            try {
                if (path != null && path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - 1);
                }
                String string = RemotePackExporter.getInstance().export(path, BasicAttachStepsProvider.getOS(settings, null), BasicAttachStepsProvider.getPlatform(settings, jdk));
                return string;
            }
            finally {
                exportRunning.compareAndSet(true, false);
            }
        }
        throw new IOException();
    }

    protected static String getOS(AttachSettings settings, String arch) {
        if (!settings.isRemote()) {
            return IntegrationUtils.getLocalPlatform((int)(arch == LINK_64ARCH ? 64 : 32));
        }
        String hostOS = settings.getHostOS();
        if (IntegrationUtils.PLATFORM_WINDOWS_CVM.equals(hostOS)) {
            return IntegrationUtils.PLATFORM_WINDOWS_OS;
        }
        if (IntegrationUtils.PLATFORM_LINUX_CVM.equals(hostOS)) {
            return IntegrationUtils.PLATFORM_LINUX_OS;
        }
        return settings.getHostOS();
    }

    protected static String getPlatform(AttachSettings settings, String jdk) {
        if (settings.isRemote() && BasicAttachStepsProvider.isCVMJVM(settings)) {
            return IntegrationUtils.PLATFORM_JAVA_CVM;
        }
        if (LINK_JDK5.equals(jdk)) {
            return IntegrationUtils.PLATFORM_JAVA_50;
        }
        return IntegrationUtils.PLATFORM_JAVA_60;
    }

    protected static boolean isCVMJVM(AttachSettings settings) {
        String hostOS = settings.getHostOS();
        return IntegrationUtils.PLATFORM_WINDOWS_CVM.equals(hostOS) || IntegrationUtils.PLATFORM_LINUX_CVM.equals(hostOS);
    }

    protected static boolean isARMJVM(AttachSettings settings) {
        String hostOS = settings.getHostOS();
        return IntegrationUtils.PLATFORM_LINUX_ARM_OS.equals(hostOS);
    }

    protected static String getCorrectJavaMsg(String currentJDK, String currentARCH) {
        if (IntegrationUtils.PLATFORM_MAC_OS.equals(IntegrationUtils.getLocalPlatform((int)-1))) {
            return LINK_JDK6UP.equals(currentJDK) ? Bundle.AttachDialog_Steps_Java6() : Bundle.AttachDialog_Steps_Java5();
        }
        if (LINK_64ARCH.equals(currentARCH)) {
            return LINK_JDK6UP.equals(currentJDK) ? Bundle.AttachDialog_Steps_Java6_64b() : Bundle.AttachDialog_Steps_Java5_64b();
        }
        return LINK_JDK6UP.equals(currentJDK) ? Bundle.AttachDialog_Steps_Java6_32b() : Bundle.AttachDialog_Steps_Java5_32b();
    }
}

