/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.UndirectedSubgraph;

public abstract class EulerianCircuit {
    public static <V, E> boolean isEulerian(UndirectedGraph<V, E> g) {
        if (!new ConnectivityInspector<V, E>(g).isGraphConnected()) {
            return false;
        }
        for (Object v : g.vertexSet()) {
            if (g.degreeOf(v) % 2 != 1) continue;
            return false;
        }
        return true;
    }

    public static <V, E> List<V> getEulerianCircuitVertices(UndirectedGraph<V, E> g) {
        if (!EulerianCircuit.isEulerian(g)) {
            return null;
        }
        LinkedList<Object> path = new LinkedList<Object>();
        UndirectedSubgraph<Object, E> sg = new UndirectedSubgraph<Object, E>(g, (Set<Object>)null, null);
        path.add(sg.vertexSet().iterator().next());
        while (sg.edgeSet().size() > 0) {
            Object v = null;
            int index = 0;
            Iterator<Object> iter = path.iterator();
            while (iter.hasNext() && sg.degreeOf(v = (Object)iter.next()) <= 0) {
                ++index;
            }
            block2: while (sg.degreeOf(v) > 0) {
                for (Object temp : sg.vertexSet()) {
                    if (!sg.containsEdge(v, temp)) continue;
                    path.add(index, temp);
                    sg.removeEdge(v, temp);
                    v = temp;
                    continue block2;
                }
            }
        }
        return path;
    }
}

