/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.List;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.util.test.FreeColTestCase;

public class OptionTest
extends FreeColTestCase {
    public void testGameOptions() {
        OptionGroup gameOptions = OptionTest.spec().getGameOptions();
        OptionTest.assertNotNull((Object)gameOptions);
        OptionTest.assertFalse((boolean)gameOptions.getOptions().isEmpty());
        OptionTest.assertNotNull((Object)OptionTest.spec().getOptionGroup("gameOptions.map"));
        OptionTest.assertNotNull((Object)OptionTest.spec().getOptionGroup("gameOptions.colony"));
        OptionTest.assertTrue((boolean)OptionTest.spec().hasOption("model.option.fogOfWar", BooleanOption.class));
        OptionTest.assertTrue((boolean)OptionTest.spec().hasOption("model.option.allowStudentSelection", BooleanOption.class));
        OptionTest.assertFalse((boolean)gameOptions.getBoolean("model.option.customIgnoreBoycott"));
        OptionTest.assertFalse((boolean)OptionTest.spec().getBoolean("model.option.customIgnoreBoycott"));
        OptionTest.assertFalse((boolean)OptionTest.spec().getBoolean("model.option.expertsHaveConnections"));
        OptionTest.assertFalse((boolean)OptionTest.spec().getBoolean("model.option.saveProductionOverflow"));
        OptionTest.assertTrue((boolean)OptionTest.spec().getBoolean("model.option.allowStudentSelection"));
    }

    public void testCloneIntegerOption() {
        IntegerOption money2;
        IntegerOption money = OptionTest.spec().getOption("model.option.startingMoney", IntegerOption.class);
        OptionTest.assertFalse((money == (money2 = money.cloneOption()) ? 1 : 0) != 0);
        OptionTest.assertEquals((String)money.getId(), (String)money2.getId());
        OptionTest.assertEquals((Object)money.getValue(), (Object)money2.getValue());
        OptionTest.assertEquals((int)money.getMinimumValue(), (int)money2.getMinimumValue());
        OptionTest.assertEquals((int)money.getMaximumValue(), (int)money2.getMaximumValue());
        money2.setValue(money.getValue() + 23);
        OptionTest.assertEquals((int)(money.getValue() + 23), (int)money2.getValue());
    }

    public void testUnitListOption() {
        List<AbstractUnit> ref = OptionTest.spec().getUnitList("model.option.refSize");
        OptionTest.assertNotNull(ref);
        for (AbstractUnit unit : ref) {
            OptionTest.assertTrue((unit.getNumber() > 0 ? 1 : 0) != 0);
            OptionTest.assertTrue((unit.getNumber() < Integer.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void testInheritsEditable() {
        OptionGroup difficulties = OptionTest.spec().getOptionGroup("difficultyLevels");
        OptionTest.assertNotNull((Object)difficulties);
        OptionTest.assertTrue((boolean)difficulties.isEditable());
        String[] levels = new String[]{"veryEasy", "easy", "medium", "hard", "veryHard"};
        String[] names = new String[]{"immigration", "natives", "monarch", "government", "other"};
        for (String level : levels) {
            OptionGroup group = difficulties.getOptionGroup("model.difficulty." + level);
            OptionTest.assertNotNull((String)("Failed to find difficulty level '" + level + "'"), (Object)group);
            OptionTest.assertFalse((String)("Difficulty level '" + level + "' should not be editable"), (boolean)group.isEditable());
            for (String name : names) {
                OptionGroup subGroup = group.getOptionGroup("model.difficulty." + name);
                OptionTest.assertNotNull((String)("Failed to find option group '" + name + "' (" + level + ")"), (Object)subGroup);
                OptionTest.assertFalse((String)("Option group '" + name + "' in '" + level + "' should not be editable"), (boolean)subGroup.isEditable());
            }
        }
        OptionGroup group = difficulties.getOptionGroup("model.difficulty.custom");
        OptionTest.assertNotNull((String)"Failed to find difficulty level 'custom'", (Object)group);
        OptionTest.assertTrue((String)"Difficulty level 'custom' should be editable", (boolean)group.isEditable());
        for (String name : names) {
            OptionGroup subGroup = group.getOptionGroup("model.difficulty." + name);
            OptionTest.assertNotNull((String)("Failed to find option group '" + name + "' (custom)"), (Object)subGroup);
            OptionTest.assertTrue((String)("Option group '" + name + "' should be editable"), (boolean)subGroup.isEditable());
        }
    }
}

