/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;

public class Datagram3 {
    private final Hash _from;
    private final byte[] _payload;
    private final Properties _options;
    private static final int INIT_DGRAM_BUFSIZE = 2048;
    private static final int MIN_DGRAM_SIZE = 34;
    private static final int MAX_DGRAM_BUFSIZE = 62464;
    private static final byte VERSION_MASK = 15;
    private static final byte OPTIONS = 16;
    private static final byte VERSION = 3;

    private Datagram3(Hash dest, byte[] data, Properties options) {
        this._from = dest;
        this._payload = data;
        this._options = options;
    }

    public static byte[] make(I2PAppContext ctx, I2PSession session, byte[] payload) throws DataFormatException {
        return Datagram3.make(ctx, session, payload, null);
    }

    public static byte[] make(I2PAppContext ctx, I2PSession session, byte[] payload, Properties options) throws DataFormatException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(payload.length + 34);
        try {
            out.write(session.getMyDestination().calculateHash().getData());
            out.write(0);
            int flags = 3;
            if (options != null && !options.isEmpty()) {
                flags = (byte)(flags | 0x10);
            }
            out.write(flags);
            if (options != null && !options.isEmpty()) {
                DataHelper.writeProperties(out, options);
            }
            out.write(payload);
            if (out.size() > 62464) {
                throw new DataFormatException("Too big");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static Datagram3 load(I2PAppContext ctx, I2PSession session, byte[] dgram) throws DataFormatException {
        if (dgram.length < 34) {
            throw new DataFormatException("Datagram3 too small: " + dgram.length);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(dgram);
        try {
            Hash rxDest = Hash.create(in);
            in.read();
            int flags = in.read();
            int version = flags & 0xF;
            if (version != 3) {
                throw new DataFormatException("Bad version " + version);
            }
            int optlen = 0;
            Properties options = null;
            if ((flags & 0x10) != 0) {
                in.mark(0);
                optlen = (int)DataHelper.readLong(in, 2);
                if (optlen > 0) {
                    in.reset();
                    if (in.available() < optlen) {
                        throw new DataFormatException("too small for options: " + dgram.length);
                    }
                    options = DataHelper.readProperties(in, null, true);
                }
                optlen += 2;
            }
            int datalen = dgram.length - (34 + optlen);
            byte[] payload = new byte[datalen];
            System.arraycopy(dgram, 34 + optlen, payload, 0, datalen);
            return new Datagram3(rxDest, payload, options);
        }
        catch (IOException e) {
            throw new DataFormatException("Error loading datagram", e);
        }
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public Hash getSender() {
        return this._from;
    }

    public Properties getOptions() {
        return this._options;
    }
}

