/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;

public class AuthorizationHandler
extends RequestHandler {
    public static final String command = "oauth_authorization";
    private static final BooleanProperty PROPERTY = new BooleanProperty("remotecontrol.permission.authorization", false);
    private static final Map<String, AuthorizationConsumer> AUTHORIZATION_CONSUMERS = new HashMap<String, AuthorizationConsumer>();
    private AuthorizationConsumer consumer;

    public static synchronized void addAuthorizationConsumer(String state, AuthorizationConsumer consumer) {
        if (AUTHORIZATION_CONSUMERS.containsKey(state)) {
            throw new IllegalArgumentException("Cannot add multiple consumers for one authorization state");
        }
        AUTHORIZATION_CONSUMERS.put(state, consumer);
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        boolean clearAll = false;
        for (Map.Entry<String, AuthorizationConsumer> entry : AUTHORIZATION_CONSUMERS.entrySet()) {
            if (!Objects.equals(this.args.get("state"), entry.getKey())) continue;
            if (this.consumer == null) {
                this.consumer = entry.getValue();
                continue;
            }
            clearAll = true;
        }
        if (clearAll) {
            AUTHORIZATION_CONSUMERS.clear();
            this.consumer = null;
            throw new RequestHandler.RequestHandlerBadRequestException("Multiple states for authorization");
        }
        if (this.consumer == null) {
            throw new RequestHandler.RequestHandlerBadRequestException("Unknown state for authorization");
        }
        this.consumer.validateRequest(this.sender, this.request, this.args);
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        ResponseRecord response = this.consumer.handleRequest(this.sender, this.request, this.args);
        if (response != null) {
            this.content = Optional.ofNullable(response.content()).orElse(this.content);
            this.contentType = Optional.ofNullable(response.type()).orElse(this.contentType);
        }
        AUTHORIZATION_CONSUMERS.entrySet().stream().filter(entry -> Objects.equals(this.consumer, entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(AUTHORIZATION_CONSUMERS::remove);
        this.consumer = null;
    }

    @Override
    public String getPermissionMessage() {
        return "Allow OAuth remote control to set credentials";
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    public BooleanProperty getPermissionPreference() {
        return PROPERTY;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"code", "state"};
    }

    public static final class ResponseRecord {
        private final String content;
        private final String type;

        public ResponseRecord(String content, String type) {
            this.content = content;
            this.type = type;
        }

        public String content() {
            return this.content;
        }

        public String type() {
            return this.type;
        }
    }

    public static interface AuthorizationConsumer {
        public void validateRequest(String var1, String var2, Map<String, String> var3) throws RequestHandler.RequestHandlerBadRequestException;

        public ResponseRecord handleRequest(String var1, String var2, Map<String, String> var3) throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException;
    }
}

